/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.ExternalSourceEntryMatcher;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.openalex.service.OpenAlexImportMetadataSourceServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenAlexPublisherExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @MockitoBean
    private LiveImportClient liveImportClient;
    @Autowired
    @Qualifier(value="openalexImportPublisherService")
    private OpenAlexImportMetadataSourceServiceImpl openAlexImportMetadataSourceService;

    @Before
    public void setUp() {
        ReflectionTestUtils.setField((Object)this.openAlexImportMetadataSourceService, (String)"liveImportClient", (Object)this.liveImportClient);
    }

    @Test
    public void findOneOpenalexImportPublisherExternalExternalSourceTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources?size=25", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItem(ExternalSourceMatcher.matchExternalSource("openalexPublisher", "openalexPublisher", false))));
    }

    @Test
    public void findOpenalexPublisherExternalSourceEntriesEmptyWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-empty.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPublisher/entries", (Object[])new Object[0]).param("query", new String[]{"empty"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findOpenalexPublisherExternalSourceEntriesTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-publisher-single.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPublisher/entries", (Object[])new Object[0]).param("query", new String[]{"Elsevier"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].id", (Object[])new Object[0]).value((Object)"P4310320990")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].display", (Object[])new Object[0]).value((Object)"Elsevier BV")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].externalSource", (Object[])new Object[0]).value((Object)"openalexPublisher")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.openalex'][0].value", (Object[])new Object[0]).value((Object)"P4310320990")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.title'][0].value", (Object[])new Object[0]).value((Object)"Elsevier BV")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['organization.legalName'][0].value", (Object[])new Object[0]).value((Object)"Elsevier BV")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][0].value", (Object[])new Object[0]).value((Object)"Elsevier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][1].value", (Object[])new Object[0]).value((Object)"elsevier.com")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][2].value", (Object[])new Object[0]).value((Object)"Elsevier Science")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][3].value", (Object[])new Object[0]).value((Object)"Uitg. Elsevier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][4].value", (Object[])new Object[0]).value((Object)"\u0627\u0644\u0633\u0641\u06cc\u0631")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][5].value", (Object[])new Object[0]).value((Object)"\u0627\u0644\u0633\u0648\u06cc\u0631")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][6].value", (Object[])new Object[0]).value((Object)"\u0627\u0646\u062a\u0634\u0627\u0631\u0627\u062a \u0627\u0644\u0632\u0648\u06cc\u0631")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][7].value", (Object[])new Object[0]).value((Object)"\u0644\u0648\u062f\u0648\u06cc\u06a9 \u0627\u0644\u0633\u0641\u06cc\u0631")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][8].value", (Object[])new Object[0]).value((Object)"\u7231\u601d\u552f\u5c14"));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findAllOpenalexPublisherExternalSourceEntriesWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-publisher-multiple.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPublisher/entries", (Object[])new Object[0]).param("query", new String[]{"Elsevier"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ExternalSourceEntryMatcher.matchExternalSourceEntry("P4310320990", "Elsevier BV", "Elsevier BV", "openalexPublisher"), ExternalSourceEntryMatcher.matchExternalSourceEntry("P4310320175", "Masson", "Masson", "openalexPublisher")})));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }
}

