/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.http.Cookie;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.matcher.MetadataValueMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authenticate.OrcidAuthenticationBean;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.RegistrationDataService;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.exception.OrcidClientException;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.orcid.jaxb.model.v3.release.record.Email;
import org.orcid.jaxb.model.v3.release.record.Emails;
import org.orcid.jaxb.model.v3.release.record.FamilyName;
import org.orcid.jaxb.model.v3.release.record.GivenNames;
import org.orcid.jaxb.model.v3.release.record.Name;
import org.orcid.jaxb.model.v3.release.record.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OrcidLoginFilterIT
extends AbstractControllerIntegrationTest {
    public static final String[] PASSWORD_ONLY = new String[]{"org.dspace.authenticate.PasswordAuthentication"};
    private static final String ORCID = "0000-1111-2222-3333";
    private static final String CODE = "123456";
    private static final String ACCESS_TOKEN = "c41e37e5-c2de-4177-91d6-ed9e9d1f31bf";
    private static final String[] ORCID_SCOPES = new String[]{"FirstScope", "SecondScope"};
    private OrcidClient originalOrcidClient;
    private OrcidClient orcidClientMock = (OrcidClient)Mockito.mock(OrcidClient.class);
    private EPerson createdEperson;
    @Autowired
    private OrcidAuthenticationBean orcidAuthentication;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private OrcidTokenService orcidTokenService;
    @Autowired
    private RegistrationDataService registrationDataService;

    @Before
    public void setup() {
        this.originalOrcidClient = this.orcidAuthentication.getOrcidClient();
        this.orcidAuthentication.setOrcidClient(this.orcidClientMock);
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", Arrays.asList("org.dspace.authenticate.OrcidAuthentication", "org.dspace.authenticate.PasswordAuthentication"));
    }

    @After
    public void after() throws Exception {
        this.orcidAuthentication.setOrcidClient(this.originalOrcidClient);
        if (this.createdEperson != null) {
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)this.createdEperson);
            this.context.restoreAuthSystemState();
        }
        this.orcidTokenService.deleteAll(this.context);
    }

    @Test
    public void testNoRedirectIfOrcidDisabled() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)PASSWORD_ONLY);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEPersonCreationViaOrcidLogin() throws Exception {
        String defaultProp = this.configurationService.getProperty("orcid.registration-data.url");
        this.configurationService.setProperty("orcid.registration-data.url", (Object)"/test-redirect?random-token={0}");
        try {
            Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
            Mockito.when((Object)this.orcidClientMock.getPerson(ACCESS_TOKEN, ORCID)).thenReturn((Object)this.buildPerson("Test", "User", "test@email.it"));
            MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andReturn();
            String redirectedUrl = mvcResult.getResponse().getRedirectedUrl();
            MatcherAssert.assertThat((Object)redirectedUrl, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.emptyString()));
            ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
            ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getPerson(ACCESS_TOKEN, ORCID);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
            Pattern pattern = Pattern.compile("test-redirect\\?random-token=([a-zA-Z0-9]+)");
            Matcher matcher = pattern.matcher(redirectedUrl);
            matcher.find();
            MatcherAssert.assertThat((Object)matcher.groupCount(), (org.hamcrest.Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)matcher.group(1), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.emptyString()));
            String rdToken = matcher.group(1);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{rdToken})).andExpect(MockMvcResultMatchers.status().is2xxSuccessful()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netId", (org.hamcrest.Matcher)Matchers.equalTo((Object)ORCID))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.registrationType", (org.hamcrest.Matcher)Matchers.equalTo((Object)RegistrationTypeEnum.ORCID.toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (org.hamcrest.Matcher)Matchers.equalTo((Object)"test@email.it"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.registrationMetadata", (org.hamcrest.Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.orcid", ORCID), MetadataMatcher.matchMetadata("eperson.firstname", "Test"), MetadataMatcher.matchMetadata("eperson.lastname", "User"))));
        }
        finally {
            this.configurationService.setProperty("orcid.registration-data.url", (Object)defaultProp);
        }
    }

    @Test
    public void testRedirectiViaOrcidLoginWithoutEmail() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        Mockito.when((Object)this.orcidClientMock.getPerson(ACCESS_TOKEN, ORCID)).thenReturn((Object)this.buildPerson("Test", "User"));
        MvcResult orcidLogin = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andReturn();
        String redirectedUrl = orcidLogin.getResponse().getRedirectedUrl();
        MatcherAssert.assertThat((Object)redirectedUrl, (org.hamcrest.Matcher)Matchers.notNullValue());
        Pattern pattern = Pattern.compile("external-login/([a-zA-Z0-9]+)");
        Matcher matcher = pattern.matcher(redirectedUrl);
        matcher.find();
        MatcherAssert.assertThat((Object)matcher.groupCount(), (org.hamcrest.Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)matcher.group(1), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.emptyString()));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getPerson(ACCESS_TOKEN, ORCID);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testWithoutSelfRegistrationEnabled() throws Exception {
        this.configurationService.setProperty("authentication-orcid.can-self-register", (Object)"false");
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        Mockito.when((Object)this.orcidClientMock.getPerson(ACCESS_TOKEN, ORCID)).thenReturn((Object)this.buildPerson("Test", "User"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000/error?status=401&code=orcid.generic-error")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie")).andReturn();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getPerson(ACCESS_TOKEN, ORCID);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testWithoutAuthorizationCode() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testEPersonLoggedInByNetId() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNetId(ORCID).withNameInMetadata("Test", "User").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andReturn();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        MatcherAssert.assertThat((Object)ePersonId, (org.hamcrest.Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ePersonId, (org.hamcrest.Matcher)Matchers.equalTo((Object)ePerson.getID().toString()));
    }

    @Test
    public void testEPersonCannotLogInByNetId() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNetId(ORCID).withNameInMetadata("Test", "User").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000/error?status=401&code=orcid.generic-error")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie"));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testEPersonLoggedInByEmail() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        Mockito.when((Object)this.orcidClientMock.getPerson(ACCESS_TOKEN, ORCID)).thenReturn((Object)this.buildPerson("Test", "User", "test@email.it"));
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andReturn();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getPerson(ACCESS_TOKEN, ORCID);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        MatcherAssert.assertThat((Object)ePersonId, (org.hamcrest.Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ePersonId, (org.hamcrest.Matcher)Matchers.equalTo((Object)ePerson.getID().toString()));
    }

    @Test
    public void testEPersonCannotLogInByEmail() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        Mockito.when((Object)this.orcidClientMock.getPerson(ACCESS_TOKEN, ORCID)).thenReturn((Object)this.buildPerson("Test", "User", "test@email.it"));
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000/error?status=401&code=orcid.generic-error")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie"));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getPerson(ACCESS_TOKEN, ORCID);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testNoAuthenticationIfAnErrorOccursRetrivingOrcidToken() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenThrow(new Throwable[]{new OrcidClientException(500, "internal error")});
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000/error?status=401&code=orcid.generic-error")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie"));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testNoAuthenticationIfAnErrorOccursRetrivingOrcidPerson() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        Mockito.when((Object)this.orcidClientMock.getPerson(ACCESS_TOKEN, ORCID)).thenThrow(new Throwable[]{new OrcidClientException(500, "Internal Error")});
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000/error?status=401&code=orcid.generic-error")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie"));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getPerson(ACCESS_TOKEN, ORCID);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testLoggedInEPersonWithProfile() throws Exception {
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Persons").withEntityType("Person").build();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withPassword(this.password).withNetId(ORCID).withNameInMetadata("Test", "User").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken("test@email.it", this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (org.hamcrest.Matcher)Matchers.is((Object)ePerson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (org.hamcrest.Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (org.hamcrest.Matcher)Matchers.is((Object)"profile")));
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andReturn();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        MatcherAssert.assertThat((Object)ePersonId, (org.hamcrest.Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ePersonId, (org.hamcrest.Matcher)Matchers.equalTo((Object)ePerson.getID().toString()));
        String profileItemId = this.getItemIdByProfileId(ePersonToken, ePersonId);
        Item profileItem = (Item)this.itemService.find(this.context, UUID.fromString(profileItemId));
        MatcherAssert.assertThat((Object)profileItem, (org.hamcrest.Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)MetadataValueMatcher.with("person.identifier.orcid", ORCID)));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)MetadataValueMatcher.with("dspace.orcid.scope", ORCID_SCOPES[0], 0)));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)MetadataValueMatcher.with("dspace.orcid.scope", ORCID_SCOPES[1], 1)));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profileItem), (org.hamcrest.Matcher)Matchers.is((Object)ACCESS_TOKEN));
    }

    @Test
    public void testRedirectToGivenTrustedUrl() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNetId(ORCID).withNameInMetadata("Test", "User").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://localhost:8080/server/api/authn/status"}).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:8080/server/api/authn/status")).andReturn().getResponse().getHeader("Authorization");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (org.hamcrest.Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (org.hamcrest.Matcher)Matchers.is((Object)"orcid")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testRedirectToGivenUntrustedUrl() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNetId(ORCID).withNameInMetadata("Test", "User").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOrcidTokenResponse(ORCID, ACCESS_TOKEN));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/orcid", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://dspace.org"}).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    private OrcidTokenResponseDTO buildOrcidTokenResponse(String orcid, String accessToken) {
        OrcidTokenResponseDTO token = new OrcidTokenResponseDTO();
        token.setAccessToken(accessToken);
        token.setOrcid(orcid);
        token.setTokenType("Bearer");
        token.setName("Test User");
        token.setScope(String.join((CharSequence)" ", ORCID_SCOPES));
        return token;
    }

    private Person buildPerson(String firstName, String lastName) {
        return this.buildPerson(firstName, lastName, null);
    }

    private Person buildPerson(String firstName, String lastName, String email) {
        Person person = new Person();
        if (email != null) {
            person.setEmails(this.buildEmails(email));
        }
        Name name = new Name();
        name.setFamilyName(new FamilyName(lastName));
        name.setGivenNames(new GivenNames(firstName));
        person.setName(name);
        return person;
    }

    private Emails buildEmails(String email) {
        Email emailObject = new Email();
        emailObject.setEmail(email);
        Emails emails = new Emails();
        emails.getEmails().add(emailObject);
        return emails;
    }

    private String getEPersonIdFromAuthorizationCookie(MvcResult mvcResult) throws ParseException, JOSEException {
        Cookie authorizationCookie = mvcResult.getResponse().getCookie("Authorization-cookie");
        SignedJWT jwt = SignedJWT.parse((String)authorizationCookie.getValue());
        return (String)jwt.getJWTClaimsSet().getClaim("eid");
    }

    private String getItemIdByProfileId(String token, String id) throws SQLException, Exception {
        MvcResult result = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        return (String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]);
    }

    private String getOrcidAccessToken(EPerson ePerson) {
        OrcidToken orcidToken = this.orcidTokenService.findByEPerson(this.context, ePerson);
        return orcidToken != null ? orcidToken.getAccessToken() : null;
    }

    private String getOrcidAccessToken(Item item) {
        OrcidToken orcidToken = this.orcidTokenService.findByProfileItem(this.context, item);
        return orcidToken != null ? orcidToken.getAccessToken() : null;
    }
}

