/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.matcher.ProcessFileTypesMatcher;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.ProcessStatus;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.ProcessLogLevel;
import org.dspace.scripts.service.ProcessService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ProcessRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ProcessService processService;
    Process process;
    LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList();

    @Before
    public void setup() throws SQLException {
        CollectionUtils.emptyIfNull((Collection)this.processService.findAll(this.context)).stream().forEach(process -> {
            try {
                this.processService.delete(this.context, process);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.parameters.add(new DSpaceCommandLineParameter("-r", "test"));
        this.parameters.add(new DSpaceCommandLineParameter("-i", null));
        this.process = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
    }

    @Test
    public void getProcessAdmin() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + this.process.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess(this.process.getName(), String.valueOf(this.process.getEPerson().getID()), this.process.getID(), this.parameters, ProcessStatus.SCHEDULED))));
    }

    @Test
    public void getProcessAdminEmptyParam() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Process process = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", new LinkedList()).build();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + process.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess(process.getName(), String.valueOf(process.getEPerson().getID()), process.getID(), new LinkedList<DSpaceCommandLineParameter>(), ProcessStatus.SCHEDULED))));
    }

    @Test
    public void getProcessAnonymousUnauthorizedException() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + this.process.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getProcessForStartedUser() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + newProcess.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess(newProcess.getName(), String.valueOf(newProcess.getEPerson().getID()), newProcess.getID(), new LinkedList<DSpaceCommandLineParameter>(), ProcessStatus.SCHEDULED))));
    }

    @Test
    public void getProcessForDifferentUserForbiddenException() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + this.process.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getProcessNotExisting() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + this.process.getID() * 23 + "17"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getAllProcessesTestAnonymous() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getAllProcessesTestAdmin() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess9.getName(), String.valueOf(newProcess9.getEPerson().getID()), newProcess9.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess8.getName(), String.valueOf(newProcess8.getEPerson().getID()), newProcess8.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess7.getName(), String.valueOf(newProcess7.getEPerson().getID()), newProcess7.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess6.getName(), String.valueOf(newProcess6.getEPerson().getID()), newProcess6.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess5.getName(), String.valueOf(newProcess5.getEPerson().getID()), newProcess5.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess4.getName(), String.valueOf(newProcess4.getEPerson().getID()), newProcess4.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(newProcess3.getEPerson().getID()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(newProcess2.getEPerson().getID()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(newProcess1.getEPerson().getID()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess.getName(), String.valueOf(newProcess.getEPerson().getID()), newProcess.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(this.process.getName(), String.valueOf(this.process.getEPerson().getID()), this.process.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 11))));
    }

    @Test
    public void getAllProcessesTestStartingUser() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", new LinkedList()).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", new LinkedList()).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", new LinkedList()).build();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getProcessFiles() throws Exception {
        this.context.setCurrentUser(this.eperson);
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        try (InputStream is = IOUtils.toInputStream((String)"Test File For Process", (String)CharEncoding.UTF_8);){
            this.processService.appendFile(this.context, newProcess, is, "inputfile", "test.csv");
        }
        Bitstream bitstream = this.processService.getBitstream(this.context, newProcess, "inputfile");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + newProcess.getID() + "/files"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.files[0].name", (Matcher)Matchers.is((Object)"test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.files[0].uuid", (Matcher)Matchers.is((Object)bitstream.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.files[0].metadata['dspace.process.filetype'][0].value", (Matcher)Matchers.is((Object)"inputfile")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + newProcess.getID() + "/files"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.files[0].name", (Matcher)Matchers.is((Object)"test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.files[0].uuid", (Matcher)Matchers.is((Object)bitstream.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.files[0].metadata['dspace.process.filetype'][0].value", (Matcher)Matchers.is((Object)"inputfile")));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getProcessFilesByFileType() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        try (InputStream is = IOUtils.toInputStream((String)"Test File For Process", (String)CharEncoding.UTF_8);){
            this.processService.appendFile(this.context, newProcess, is, "inputfile", "test.csv");
        }
        Bitstream bitstream = this.processService.getBitstream(this.context, newProcess, "inputfile");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + newProcess.getID() + "/files/inputfile"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams[0].name", (Matcher)Matchers.is((Object)"test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams[0].uuid", (Matcher)Matchers.is((Object)bitstream.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams[0].metadata['dspace.process.filetype'][0].value", (Matcher)Matchers.is((Object)"inputfile")));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + newProcess.getID() + "/files/inputfile"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams[0].name", (Matcher)Matchers.is((Object)"test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams[0].uuid", (Matcher)Matchers.is((Object)bitstream.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams[0].metadata['dspace.process.filetype'][0].value", (Matcher)Matchers.is((Object)"inputfile")));
    }

    @Test
    public void getProcessFilesTypes() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", new LinkedList()).build();
        try (InputStream is = IOUtils.toInputStream((String)"Test File For Process", (String)CharEncoding.UTF_8);){
            this.processService.appendFile(this.context, newProcess, is, "inputfile", "test.csv");
        }
        LinkedList<String> fileTypesToCheck = new LinkedList<String>();
        fileTypesToCheck.add("inputfile");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + newProcess.getID() + "/filetypes"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ProcessFileTypesMatcher.matchProcessFileTypes("filetypes-" + newProcess.getID(), fileTypesToCheck)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + newProcess.getID() + "/filetypes"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ProcessFileTypesMatcher.matchProcessFileTypes("filetypes-" + newProcess.getID(), fileTypesToCheck)));
    }

    @Test
    public void getProcessFilesTypesForbidden() throws Exception {
        try (InputStream is = IOUtils.toInputStream((String)"Test File For Process", (String)CharEncoding.UTF_8);){
            this.processService.appendFile(this.context, this.process, is, "inputfile", "test.csv");
        }
        LinkedList<String> fileTypesToCheck = new LinkedList<String>();
        fileTypesToCheck.add("inputfile");
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + this.process.getID() + "/filetypes"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getProcessFilesTypesUnAuthorized() throws Exception {
        try (InputStream is = IOUtils.toInputStream((String)"Test File For Process", (String)CharEncoding.UTF_8);){
            this.processService.appendFile(this.context, this.process, is, "inputfile", "test.csv");
        }
        LinkedList<String> fileTypesToCheck = new LinkedList<String>();
        fileTypesToCheck.add("inputfile");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + this.process.getID() + "/filetypes"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getProcessFilesTypesRandomProcessId() throws Exception {
        try (InputStream is = IOUtils.toInputStream((String)"Test File For Process", (String)CharEncoding.UTF_8);){
            this.processService.appendFile(this.context, this.process, is, "inputfile", "test.csv");
        }
        LinkedList<String> fileTypesToCheck = new LinkedList<String>();
        fileTypesToCheck.add("inputfile");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + new Random() + "/filetypes"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void searchProcessTestForbidden() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void searchProcessTestUnauthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void searchProcessTestByUser() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(this.process.getName(), String.valueOf(this.admin.getID().toString()), this.process.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess7.getName(), String.valueOf(this.admin.getID().toString()), newProcess7.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess8.getName(), String.valueOf(this.admin.getID().toString()), newProcess8.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess9.getName(), String.valueOf(this.admin.getID().toString()), newProcess9.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 4))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess.getName(), String.valueOf(this.eperson.getID().toString()), newProcess.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess4.getName(), String.valueOf(this.eperson.getID().toString()), newProcess4.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess5.getName(), String.valueOf(this.eperson.getID().toString()), newProcess5.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess6.getName(), String.valueOf(this.eperson.getID().toString()), newProcess6.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7))));
    }

    @Test
    public void searchProcessTestByProcessStatus() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("processStatus", new String[]{"FAILED"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess7.getName(), String.valueOf(this.admin.getID().toString()), newProcess7.getID(), this.parameters, ProcessStatus.FAILED), ProcessMatcher.matchProcess(newProcess9.getName(), String.valueOf(this.admin.getID().toString()), newProcess9.getID(), this.parameters, ProcessStatus.FAILED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2))));
    }

    @Test
    public void searchProcessTestByScriptName() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"another-mock-script", this.parameters).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("scriptName", new String[]{"another-mock-script"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess8.getName(), String.valueOf(this.admin.getID().toString()), newProcess8.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1))));
    }

    @Test
    public void searchProcessTestByScriptNameAndUserId() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"another-mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"another-mock-script", this.parameters).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("scriptName", new String[]{"another-mock-script"}).param("userId", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess7.getName(), String.valueOf(this.admin.getID().toString()), newProcess7.getID(), this.parameters, ProcessStatus.FAILED), ProcessMatcher.matchProcess(newProcess8.getName(), String.valueOf(this.admin.getID().toString()), newProcess8.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2))));
    }

    @Test
    public void searchProcessTestByUserIdAndProcessStatus() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"another-mock-script", this.parameters).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"another-mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("processStatus", new String[]{"FAILED"}).param("userId", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess9.getName(), String.valueOf(this.admin.getID().toString()), newProcess9.getID(), this.parameters, ProcessStatus.FAILED), ProcessMatcher.matchProcess(newProcess8.getName(), String.valueOf(this.admin.getID().toString()), newProcess8.getID(), this.parameters, ProcessStatus.FAILED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2))));
    }

    @Test
    public void searchProcessTestByUserIdAndProcessStatusAndScriptName() throws Exception {
        Process newProcess = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess4 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).build();
        Process newProcess5 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess6 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"another-mock-script", this.parameters).build();
        Process newProcess7 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"another-mock-script", this.parameters).build();
        Process newProcess8 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"another-mock-script", this.parameters).withProcessStatus(ProcessStatus.FAILED).build();
        Process newProcess9 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("processStatus", new String[]{"FAILED"}).param("userId", new String[]{this.eperson.getID().toString()}).param("scriptName", new String[]{"mock-script"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ProcessMatcher.matchProcess("mock-script", String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.FAILED), ProcessMatcher.matchProcess("mock-script", String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.FAILED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2))));
    }

    @Test
    public void searchProcessTestNoParametersBadRequest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void searchProcessTestUnparseableProcessStatusParamBadRequest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("processStatus", new String[]{"not-a-valid-status"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void searchProcessTestInvalidEPersonUuid() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void searchProcessTestByUserSortedOnStartTimeAsc() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"startTime,asc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3))));
    }

    @Test
    public void searchProcessTestByUserSortedOnStartTimeDesc() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"startTime,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3))));
    }

    @Test
    public void searchProcessTestByUserSortedOnCreationTimeAsc() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withCreationTime(LocalDate.of(2000, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC)).withStartAndEndTime("1990-01-01", "1995-01-01").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withCreationTime(LocalDate.of(2005, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC)).withStartAndEndTime(null, null).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withCreationTime(LocalDate.of(2010, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC)).withStartAndEndTime("2015-01-01", "2020-01-01").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"creationTime,asc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3))));
    }

    @Test
    public void searchProcessTestByUserSortedOnCreationTimeDesc() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withCreationTime(LocalDate.of(2000, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC)).withStartAndEndTime("1990-01-01", "1995-01-01").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withCreationTime(LocalDate.of(2005, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC)).withStartAndEndTime(null, null).build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withCreationTime(LocalDate.of(2010, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC)).withStartAndEndTime("2015-01-01", "2020-01-01").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"creationTime,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3))));
    }

    @Test
    public void searchProcessTestByUserSortedOnEndTimeAsc() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"endTime,asc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3))));
    }

    @Test
    public void searchProcessTestByUserSortedOnEndTimeDesc() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"endTime,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3))));
    }

    @Test
    public void searchProcessTestByUserSortedOnMultipleBadRequest() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"endTime,desc"}).param("sort", new String[]{"startTime,desc"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void searchProcessTestByUserSortedOnDefault() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(newProcess3.getName(), String.valueOf(this.eperson.getID().toString()), newProcess3.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess2.getName(), String.valueOf(this.eperson.getID().toString()), newProcess2.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(newProcess1.getName(), String.valueOf(this.eperson.getID().toString()), newProcess1.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3))));
    }

    @Test
    public void searchProcessTestByUserSortedOnNonExistingBadRequest() throws Exception {
        Process newProcess1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        Process newProcess2 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process newProcess3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/byProperty", (Object[])new Object[0]).param("userId", new String[]{this.eperson.getID().toString()}).param("sort", new String[]{"eaz,desc"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testFindByCurrentUser() throws Exception {
        Process process1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        ProcessBuilder.createProcess((Context)this.context, (EPerson)this.admin, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-11", "1990-01-19").build();
        Process process3 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-12", "1990-01-18").build();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/processes/search/own", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.processes", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(process3.getName(), this.eperson.getID().toString(), process3.getID(), this.parameters, ProcessStatus.SCHEDULED), ProcessMatcher.matchProcess(process1.getName(), this.eperson.getID().toString(), process1.getID(), this.parameters, ProcessStatus.SCHEDULED)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2))));
    }

    @Test
    public void getProcessOutput() throws Exception {
        this.context.setCurrentUser(this.eperson);
        Process process1 = ProcessBuilder.createProcess((Context)this.context, (EPerson)this.eperson, (String)"mock-script", this.parameters).withStartAndEndTime("1990-01-10", "1990-01-20").build();
        try (InputStream is = IOUtils.toInputStream((String)"Test File For Process", (String)CharEncoding.UTF_8);){
            this.processService.appendLog(process1.getID().intValue(), process1.getName(), "testlog", ProcessLogLevel.INFO);
        }
        this.processService.createLogBitstream(this.context, process1);
        LinkedList<String> fileTypesToCheck = new LinkedList<String>();
        fileTypesToCheck.add("inputfile");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + process1.getID() + "/output"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)(process1.getID() + "-" + process1.getName() + ".log")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)(process1.getID() + "-" + process1.getName() + ".log")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['dspace.process.filetype'][0].value", (Matcher)Matchers.is((Object)"script_output")));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + process1.getID() + "/output"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)(process1.getID() + "-" + process1.getName() + ".log")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)(process1.getID() + "-" + process1.getName() + ".log")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['dspace.process.filetype'][0].value", (Matcher)Matchers.is((Object)"script_output")));
    }
}

