/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.QASourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.QAEventBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class QASourceRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    private Item target;

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withTitle("Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        this.target = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item").build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("qaevents.sources", (Object)new String[]{"openaire", "coar-notify", "test-source", "test-source-2"});
    }

    @Test
    public void testFindAll() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", "Title 1");
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", "Title 2");
        this.context.setCurrentUser(this.eperson);
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", "Title 3");
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", "Title 4");
        this.createEvent("test-source", "TOPIC/TEST/1", "Title 5");
        this.createEvent("test-source", "TOPIC/TEST/1", "Title 6");
        this.createEvent("coar-notify", "TOPIC", "Title 7");
        this.context.setCurrentUser(this.eperson);
        this.createEvent("coar-notify", "TOPIC", "Title 8");
        this.createEvent("coar-notify", "TOPIC", "Title 9");
        this.context.setCurrentUser(null);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancesources", (Matcher)Matchers.contains((Matcher[])new Matcher[]{QASourceMatcher.matchQASourceEntry("openaire", 4), QASourceMatcher.matchQASourceEntry("coar-notify", 3), QASourceMatcher.matchQASourceEntry("test-source", 2), QASourceMatcher.matchQASourceEntry("test-source-2", 0)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancesources", (Matcher)Matchers.contains(QASourceMatcher.matchQASourceEntry("coar-notify", 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void testFindAllUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", "Title 1");
        this.createEvent("test-source", "TOPIC/TEST/1", "Title 4");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testFindOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("Test community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("Test collection").build();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", "Title 1");
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", "Title 2");
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", "Title 3");
        this.createEvent("test-source", "TOPIC/TEST/1", "Title 4");
        this.createEvent("test-source", "TOPIC/TEST/1", "Title 5");
        this.context.setCurrentUser(this.admin);
        Item target1 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Title 7").build();
        this.createEvent("coar-notify", "TOPIC", target1);
        this.context.setCurrentUser(this.eperson);
        this.createEvent("coar-notify", "TOPIC", "Title 8");
        this.createEvent("coar-notify", "TOPIC", "Title 9");
        this.context.setCurrentUser(null);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/openaire", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QASourceMatcher.matchQASourceEntry("openaire", 3)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/coar-notify", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QASourceMatcher.matchQASourceEntry("coar-notify", 3)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/test-source", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QASourceMatcher.matchQASourceEntry("test-source", 2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/test-source-2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QASourceMatcher.matchQASourceEntry("test-source-2", 0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/unknown-test-source", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/openaire", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/unknown-test-source", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/coar-notify", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QASourceMatcher.matchQASourceEntry("coar-notify", 2)));
    }

    @Test
    public void testFindOneForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", "Title 1");
        this.createEvent("test-source", "TOPIC/TEST/1", "Title 4");
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/openaire", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testFindOneUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", "Title 1");
        this.createEvent("test-source", "TOPIC/TEST/1", "Title 4");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/openaire", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testFindAllByTarget() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("Test community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("Test collection").build();
        Item target1 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Test item1").build();
        Item target2 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Test item2").build();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", target1);
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", target1);
        this.createEvent("test-source", "TOPIC/TEST/1", target1);
        this.createEvent("test-source", "TOPIC/TEST/1", target2);
        this.context.setCurrentUser(this.eperson);
        Item target3 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Test item3").build();
        this.context.setCurrentUser(null);
        this.createEvent("coar-notify", "TOPIC", target3);
        this.createEvent("coar-notify", "TOPIC2", target3);
        this.createEvent("coar-notify", "TOPIC", target2);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0]).param("target", new String[]{target1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancesources", (Matcher)Matchers.contains((Matcher[])new Matcher[]{QASourceMatcher.matchQASourceEntry("openaire:" + target1.getID().toString(), 2), QASourceMatcher.matchQASourceEntry("test-source:" + target1.getID().toString(), 1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0]).param("target", new String[]{target2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancesources", (Matcher)Matchers.contains((Matcher[])new Matcher[]{QASourceMatcher.matchQASourceEntry("coar-notify:" + target2.getID().toString(), 1), QASourceMatcher.matchQASourceEntry("test-source:" + target2.getID().toString(), 1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0]).param("target", new String[]{target3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancesources", (Matcher)Matchers.contains(QASourceMatcher.matchQASourceEntry("coar-notify:" + target3.getID().toString(), 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0]).param("target", new String[]{target1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0]).param("target", new String[]{target2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0]).param("target", new String[]{target3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancesources", (Matcher)Matchers.contains(QASourceMatcher.matchQASourceEntry("coar-notify:" + target3.getID().toString(), 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void testFindByTargetBadRequest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("Test community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("Test collection").build();
        Item target1 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Test item1").build();
        Item target2 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Test item2").build();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", target1);
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", target1);
        this.createEvent("test-source", "TOPIC/TEST/1", target1);
        this.createEvent("test-source", "TOPIC/TEST/1", target2);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testFindByTargetUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("Test community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("Test collection").build();
        Item target1 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Test item1").build();
        Item target2 = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Test item2").build();
        this.createEvent("openaire", "TOPIC/OPENAIRE/1", target1);
        this.createEvent("openaire", "TOPIC/OPENAIRE/2", target1);
        this.createEvent("test-source", "TOPIC/TEST/1", target1);
        this.createEvent("test-source", "TOPIC/TEST/1", target2);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/search/byTarget", (Object[])new Object[0]).param("target", new String[]{target1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    private QAEvent createEvent(String source, String topic, String title) {
        return QAEventBuilder.createTarget((Context)this.context, (Item)this.target).withSource(source).withTopic(topic).withTitle(title).build();
    }

    private QAEvent createEvent(String source, String topic, Item item) {
        return QAEventBuilder.createTarget((Context)this.context, (Item)item).withSource(source).withTopic(topic).withTitle(item.getName()).build();
    }
}

