/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.matcher.RegistrationMatcher;
import org.dspace.app.rest.model.RegistrationRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.repository.RegistrationRestRepository;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.EPersonBuilder;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.CaptchaServiceImpl;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.InvalidReCaptchaException;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.dao.RegistrationDataDAO;
import org.dspace.eperson.service.CaptchaService;
import org.dspace.eperson.service.RegistrationDataService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RegistrationRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private CaptchaServiceImpl captchaService;
    @Autowired
    private RegistrationDataDAO registrationDataDAO;
    @Autowired
    private RegistrationDataService registrationDataService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private RegistrationRestRepository registrationRestRepository;
    @Autowired
    private ObjectMapper mapper;
    private static MockedStatic<Email> emailMockedStatic;

    @After
    public void tearDown() throws Exception {
        for (RegistrationData registrationData : this.registrationDataDAO.findAll(this.context, RegistrationData.class)) {
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
        }
    }

    @BeforeClass
    public static void init() throws Exception {
        emailMockedStatic = Mockito.mockStatic(Email.class);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        emailMockedStatic.close();
    }

    @Test
    public void findByTokenTestExistingUserTest() throws Exception {
        String email = this.eperson.getEmail();
        this.createTokenForEmail(email);
        RegistrationData registrationData = this.registrationDataDAO.findByEmail(this.context, email);
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, this.eperson.getID()))));
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
            email = "newUser@testnewuser.com";
            this.createTokenForEmail(email);
            registrationData = this.registrationDataDAO.findByEmail(this.context, email);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, null))));
        }
        finally {
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
        }
    }

    @Test
    public void findByTokenTestNewUserTest() throws Exception {
        String email = "newUser@testnewuser.com";
        this.createTokenForEmail(email);
        RegistrationData registrationData = this.registrationDataDAO.findByEmail(this.context, email);
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, null))));
        }
        finally {
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
        }
    }

    @Test
    public void findByTokenNotExistingTokenTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registration/search/findByToken", (Object[])new Object[0]).param("token", new String[]{"ThisTokenDoesNotExist"})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private void createTokenForEmail(String email) throws Exception {
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(email);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registrationFlowTest() throws Exception {
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        Assert.assertEquals((long)0L, (long)registrationDataList.size());
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
            String newEmail = "newEPersonTest@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertTrue((registrationDataList.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) || StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
            this.configurationService.setProperty("user.registration", (Object)false);
            newEmail = "newEPersonTestTwo@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is(401));
            Assert.assertEquals((long)2L, (long)registrationDataList.size());
            Assert.assertTrue((!StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) && !StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterDomainRegistered() throws Exception {
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            this.configurationService.setProperty("authentication-password.domain.valid", (Object)"test.com");
            RegistrationRest registrationRest = new RegistrationRest();
            String email = "testPerson@test.com";
            registrationRest.setEmail(email);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)email));
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterDomainNotRegistered() throws Exception {
        try {
            this.configurationService.setProperty("authentication-password.domain.valid", (Object)"test.com");
            RegistrationRest registrationRest = new RegistrationRest();
            String email = "testPerson@bladibla.com";
            registrationRest.setEmail(email);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterMailAddressRegistered() throws Exception {
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            this.context.turnOffAuthorisationSystem();
            String email = "test@gmail.com";
            EPersonBuilder.createEPerson((Context)this.context).withEmail(email).withCanLogin(true).build();
            this.context.restoreAuthSystemState();
            RegistrationRest registrationRest = new RegistrationRest();
            registrationRest.setEmail(email);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)email));
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forgotPasswordTest() throws Exception {
        this.configurationService.setProperty("user.registration", (Object)false);
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            Assert.assertEquals((long)0L, (long)registrationDataList.size());
            RegistrationRest registrationRest = new RegistrationRest();
            registrationRest.setEmail(this.eperson.getEmail());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_FORGOT}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnauthorizedForgotPasswordTest() throws Exception {
        this.configurationService.setProperty("user.registration", (Object)false);
        this.configurationService.setProperty("user.forgot-password", (Object)false);
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            Assert.assertEquals((long)0L, (long)registrationDataList.size());
            RegistrationRest registrationRest = new RegistrationRest();
            registrationRest.setEmail(this.eperson.getEmail());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_FORGOT}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)0L, (long)registrationDataList.size());
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    @Test
    public void registrationFlowWithNoHeaderCaptchaTokenTest() throws Exception {
        String originVerification = this.configurationService.getProperty("registration.verification.enabled");
        String originSecret = this.configurationService.getProperty("google.recaptcha.key.secret");
        String originVresion = this.configurationService.getProperty("google.recaptcha.version");
        this.reloadCaptchaProperties("true", "test-secret", "v2");
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.reloadCaptchaProperties(originVerification, originSecret, originVresion);
    }

    @Test
    public void registrationFlowWithInvalidCaptchaTokenTest() throws Exception {
        String originVerification = this.configurationService.getProperty("registration.verification.enabled");
        String originSecret = this.configurationService.getProperty("google.recaptcha.key.secret");
        String originVresion = this.configurationService.getProperty("google.recaptcha.version");
        this.reloadCaptchaProperties("true", "test-secret", "v2");
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        String captchaToken = "invalid-captcha-Token";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).header("x-captcha-payload", new Object[]{captchaToken}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.reloadCaptchaProperties(originVerification, originSecret, originVresion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registrationFlowWithValidCaptchaTokenTest() throws Exception {
        String originVerification = this.configurationService.getProperty("registration.verification.enabled");
        String originSecret = this.configurationService.getProperty("google.recaptcha.key.secret");
        String originVresion = this.configurationService.getProperty("google.recaptcha.version");
        this.reloadCaptchaProperties("true", "test-secret", "v2");
        String captchaToken = "123456";
        String captchaToken1 = "12345676866";
        CaptchaService captchaServiceMock = (CaptchaService)Mockito.mock(CaptchaService.class);
        this.registrationRestRepository.setCaptchaService(captchaServiceMock);
        ((CaptchaService)Mockito.doThrow((Throwable[])new Throwable[]{new InvalidReCaptchaException("Invalid captcha token")}).when((Object)captchaServiceMock)).processResponse((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((CaptchaService)Mockito.doNothing().when((Object)captchaServiceMock)).processResponse((String)ArgumentMatchers.eq((Object)captchaToken), (String)ArgumentMatchers.eq((Object)"register_email"));
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        Assert.assertEquals((long)0L, (long)registrationDataList.size());
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).header("x-captcha-payload", new Object[]{captchaToken1}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).header("x-captcha-payload", new Object[]{captchaToken}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
            String newEmail = "newEPersonTest@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).header("x-captcha-payload", new Object[]{captchaToken}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertTrue((registrationDataList.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) || StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
            this.configurationService.setProperty("user.registration", (Object)false);
            newEmail = "newEPersonTestTwo@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).header("x-captcha-payload", new Object[]{captchaToken}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is(401));
            Assert.assertEquals((long)2L, (long)registrationDataList.size());
            Assert.assertTrue((!StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) && !StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
        }
        finally {
            this.registrationRestRepository.setCaptchaService((CaptchaService)this.captchaService);
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
            this.reloadCaptchaProperties(originVerification, originSecret, originVresion);
        }
    }

    private void reloadCaptchaProperties(String verification, String secret, String version) {
        this.configurationService.setProperty("registration.verification.enabled", (Object)verification);
        this.configurationService.setProperty("google.recaptcha.key.secret", (Object)secret);
        this.configurationService.setProperty("google.recaptcha.version", (Object)version);
        this.captchaService.init();
    }

    @Test
    public void accountEndpoint_WithoutAccountTypeParam() throws Exception {
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void accountEndpoint_WrongAccountTypeParam() throws Exception {
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"nonValidValue"}).content(this.mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void givenRegistrationData_whenPatchInvalidValue_thenUnprocessableEntityResponse() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        registrationRest.setUser(this.eperson.getID());
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        RegistrationData registrationData = this.registrationDataService.findByEmail(this.context, registrationRest.getEmail());
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        String token = registrationData.getToken();
        String newMail = null;
        String patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        newMail = "test@email.com";
        patchContent = this.getPatchContent(List.of(new AddOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        newMail = "invalidemail!!!!";
        patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void givenRegistrationData_whenPatchWithInvalidToken_thenUnprocessableEntityResponse() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        registrationRest.setUser(this.eperson.getID());
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        RegistrationData registrationData = this.registrationDataService.findByEmail(this.context, registrationRest.getEmail());
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        String token = null;
        String newMail = "validemail@email.com";
        String patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        token = "notexistingtoken";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.context.turnOffAuthorisationSystem();
        registrationData = (RegistrationData)this.context.reloadEntity((ReloadableEntity)registrationData);
        this.registrationDataService.markAsExpired(this.context, registrationData);
        this.context.commit();
        this.context.restoreAuthSystemState();
        registrationData = (RegistrationData)this.context.reloadEntity((ReloadableEntity)registrationData);
        Assert.assertThat((Object)registrationData.getExpires(), (Matcher)Matchers.notNullValue());
        token = registrationData.getToken();
        newMail = "validemail@email.com";
        patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void givenRegistrationDataWithEmail_whenPatchForReplaceEmail_thenSuccessfullResponse() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        registrationRest.setUser(this.eperson.getID());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        RegistrationData registrationData = this.registrationDataService.findByEmail(this.context, registrationRest.getEmail());
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        String token = registrationData.getToken();
        String newMail = "vins-01@fake.mail";
        String patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
    }

    @Test
    public void givenRegistrationDataWithoutEmail_whenPatchForAddEmail_thenSuccessfullResponse() throws Exception {
        RegistrationData registrationData = this.createNewRegistrationData("0000-1111-2222-3333", RegistrationTypeEnum.ORCID);
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        String token = registrationData.getToken();
        String newMail = "vins-01@fake.mail";
        String patchContent = this.getPatchContent(List.of(new AddOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
    }

    @Test
    public void givenRegistrationDataWithEmail_whenPatchForReplaceEmail_thenNewRegistrationDataCreated() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        registrationRest.setUser(this.eperson.getID());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        RegistrationData registrationData = this.registrationDataService.findByEmail(this.context, registrationRest.getEmail());
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        String token = registrationData.getToken();
        String newMail = "vins-01@fake.mail";
        String patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        RegistrationData newRegistration = this.registrationDataService.findByEmail(this.context, newMail);
        Assert.assertThat((Object)newRegistration, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)newRegistration.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        Assert.assertThat((Object)newRegistration.getEmail(), (Matcher)Matchers.equalTo((Object)newMail));
        Assert.assertThat((Object)newRegistration.getEmail(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)registrationData.getEmail())));
        Assert.assertThat((Object)newRegistration.getToken(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)registrationData.getToken())));
        registrationData = (RegistrationData)this.context.reloadEntity((ReloadableEntity)registrationData);
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.nullValue());
    }

    @Test
    public void givenRegistrationDataWithoutEmail_whenPatchForReplaceEmail_thenNewRegistrationDataCreated() throws Exception {
        RegistrationData registrationData = this.createNewRegistrationData("0000-1111-2222-3333", RegistrationTypeEnum.ORCID);
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        String token = registrationData.getToken();
        String newMail = "vins-01@fake.mail";
        String patchContent = this.getPatchContent(List.of(new AddOperation("/email", (Object)newMail)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        RegistrationData newRegistration = this.registrationDataService.findByEmail(this.context, newMail);
        Assert.assertThat((Object)newRegistration, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)newRegistration.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        Assert.assertThat((Object)newRegistration.getEmail(), (Matcher)Matchers.equalTo((Object)newMail));
        Assert.assertThat((Object)newRegistration.getEmail(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)registrationData.getEmail())));
        Assert.assertThat((Object)newRegistration.getToken(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)registrationData.getToken())));
        registrationData = (RegistrationData)this.context.reloadEntity((ReloadableEntity)registrationData);
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.nullValue());
    }

    @Test
    public void givenRegistrationDataWithoutEmail_whenPatchForAddEmail_thenExternalLoginSent() throws Exception {
        RegistrationData registrationData = this.createNewRegistrationData("0000-1111-2222-3333", RegistrationTypeEnum.ORCID);
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        String token = registrationData.getToken();
        String newMail = "vins-01@fake.mail";
        String patchContent = this.getPatchContent(List.of(new AddOperation("/email", (Object)newMail)));
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).addRecipient(newMail);
        ((Email)Mockito.verify((Object)spy)).addArgument((Object)ArgumentMatchers.contains((String)RegistrationTypeEnum.ORCID.getLink()));
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).send();
    }

    @Test
    public void givenRegistrationDataWithEmail_whenPatchForNewEmail_thenExternalLoginSent() throws Exception {
        RegistrationData registrationData = this.createNewRegistrationData("0000-1111-2222-3333", RegistrationTypeEnum.ORCID);
        String token = registrationData.getToken();
        String newMail = "vincenzo.mecca@orcid.com";
        String patchContent = this.getPatchContent(List.of(new AddOperation("/email", (Object)newMail)));
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).addRecipient(newMail);
        ((Email)Mockito.verify((Object)spy)).addArgument((Object)ArgumentMatchers.contains((String)registrationData.getRegistrationType().getLink()));
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).send();
        registrationData = this.registrationDataService.findByEmail(this.context, newMail);
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        token = registrationData.getToken();
        newMail = "vins-01@fake.mail";
        patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", (Object)newMail)));
        spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).addRecipient(newMail);
        ((Email)Mockito.verify((Object)spy)).addArgument((Object)ArgumentMatchers.contains((String)registrationData.getRegistrationType().getLink()));
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).send();
    }

    @Test
    public void givenRegistrationDataWithEmail_whenPatchForExistingEPersonEmail_thenReviewAccountLinkSent() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        registrationRest.setNetId("0000-0000-0000-0000");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{RegistrationRestRepository.TYPE_REGISTER}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        RegistrationData registrationData = this.registrationDataService.findByEmail(this.context, registrationRest.getEmail());
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        this.context.turnOffAuthorisationSystem();
        EPerson vins = EPersonBuilder.createEPerson((Context)this.context).withEmail("vins-01@fake.mail").withNameInMetadata("Vincenzo", "Mecca").withOrcid("0101-0101-0101-0101").build();
        this.context.restoreAuthSystemState();
        String token = registrationData.getToken();
        String vinsEmail = vins.getEmail();
        String patchContent = this.getPatchContent(List.of(new ReplaceOperation("/email", (Object)vins.getEmail())));
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).addRecipient(vinsEmail);
        ((Email)Mockito.verify((Object)spy)).addArgument((Object)ArgumentMatchers.contains((String)RegistrationTypeEnum.VALIDATION_ORCID.getLink()));
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).send();
    }

    @Test
    public void givenRegistrationDataWithoutEmail_whenPatchForExistingAccount_thenReviewAccountSent() throws Exception {
        RegistrationData registrationData = this.createNewRegistrationData("0000-1111-2222-3333", RegistrationTypeEnum.ORCID);
        Assert.assertThat((Object)registrationData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)registrationData.getToken(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        this.context.turnOffAuthorisationSystem();
        EPerson vins = EPersonBuilder.createEPerson((Context)this.context).withEmail("vins-01@fake.mail").withNameInMetadata("Vincenzo", "Mecca").withOrcid("0101-0101-0101-0101").build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        String token = registrationData.getToken();
        String vinsEmail = vins.getEmail();
        String patchContent = this.getPatchContent(List.of(new AddOperation("/email", (Object)vins.getEmail())));
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/registrations/" + registrationData.getID()), (Object[])new Object[0]).param("token", new String[]{token}).content(patchContent).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).addRecipient(vinsEmail);
        ((Email)Mockito.verify((Object)spy)).addArgument((Object)ArgumentMatchers.contains((String)RegistrationTypeEnum.VALIDATION_ORCID.getLink()));
        ((Email)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).send();
    }

    private RegistrationData createNewRegistrationData(String netId, RegistrationTypeEnum type) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        RegistrationData registrationData = this.registrationDataService.create(this.context, netId, type);
        this.context.commit();
        this.context.restoreAuthSystemState();
        return registrationData;
    }
}

