/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.http.Cookie;
import java.text.ParseException;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EPersonBuilder;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.saml2.DSpaceRelyingPartyRegistrationRepository;
import org.dspace.services.ConfigurationService;
import org.dspace.util.UUIDUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.StringEndsWith;
import org.hamcrest.core.StringStartsWith;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SamlAuthenticationRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private DSpaceRelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    @Autowired
    private EPersonService ePersonService;
    private EPerson testUser;

    @Before
    public void beforeEach() throws Exception {
        this.testUser = null;
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", List.of("org.dspace.authenticate.SamlAuthentication", "org.dspace.authenticate.PasswordAuthentication"));
        this.configurationService.setProperty("authentication-saml.autoregister", (Object)true);
        this.configurationService.setProperty("saml-relying-party.testrp.asserting-party.entity-id", (Object)"urn:idp.example.com");
        this.configurationService.setProperty("saml-relying-party.testrp.asserting-party.single-sign-on.url", (Object)"http://idp.example.com/samlp");
        this.configurationService.setProperty("saml-relying-party.testrp.asserting-party.single-sign-on.binding", (Object)"REDIRECT");
        this.configurationService.setProperty("saml-relying-party.testrp.signing.credentials.0.private-key-location", (Object)"classpath:org/dspace/app/rest/testrp-rp-private.key");
        this.configurationService.setProperty("saml-relying-party.testrp.signing.credentials.0.certificate-location", (Object)"classpath:org/dspace/app/rest/testrp-rp-certificate.crt");
        this.relyingPartyRegistrationRepository.reload();
    }

    @After
    public void afterEach() throws Exception {
        if (this.testUser != null) {
            EPersonBuilder.deleteEPerson((UUID)this.testUser.getID());
        }
    }

    @Test
    public void testSamlMetadata() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/saml2/service-provider-metadata/testrp", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is2xxSuccessful()).andExpect(MockMvcResultMatchers.header().string("content-type", (Matcher)new StringStartsWith("application/samlmetadata+xml"))).andExpect(MockMvcResultMatchers.xpath((String)"/EntityDescriptor/SPSSODescriptor/AssertionConsumerService/@Location", (Object[])new Object[0]).string("http://localhost/saml2/assertion-consumer/testrp")).andExpect(MockMvcResultMatchers.xpath((String)"/EntityDescriptor/SPSSODescriptor/KeyDescriptor[@use='signing']/KeyInfo/X509Data/X509Certificate", (Object[])new Object[0]).string((Matcher)new AllOf(new Matcher[]{new StringStartsWith("MIICgTCCAeoCCQCuVzyqFgMSyDAN"), new StringEndsWith("RZ/nbTJ7VTeZOSyRoVn5XHhpuJ0B")}))).andReturn();
    }

    @Test
    public void testSamlInitiateLogin() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/saml2/authenticate/testrp", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.header().string("location", (Matcher)new StringStartsWith("http://idp.example.com/samlp?SAMLRequest="))).andReturn();
    }

    @Test
    public void testSamlAttributesReceivedForExistingUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson((Context)this.context).withEmail("alyssa@dspace.org").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/saml", (Object[])new Object[0]).requestAttr("org.dspace.saml.EMAIL", (Object)"alyssa@dspace.org")).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN")).andReturn();
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        Assert.assertNotNull((Object)ePersonId);
        Assert.assertEquals((Object)this.testUser.getID().toString(), (Object)ePersonId);
    }

    @Test
    public void testSamlAttributesReceivedForNonexistentUser() throws Exception {
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/saml", (Object[])new Object[0]).requestAttr("org.dspace.saml.NAME_ID", (Object)"001").requestAttr("org.dspace.saml.EMAIL", (Object)"ben@dspace.org").requestAttr("org.dspace.saml.GIVEN_NAME", (Object)"Ben").requestAttr("org.dspace.saml.SURNAME", (Object)"Bitdiddle")).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN")).andReturn();
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        this.testUser = (EPerson)this.ePersonService.find(this.context, UUIDUtils.fromString((String)ePersonId));
        Assert.assertNotNull((Object)this.testUser);
        Assert.assertEquals((Object)"001", (Object)this.testUser.getNetid());
        Assert.assertEquals((Object)"ben@dspace.org", (Object)this.testUser.getEmail());
        Assert.assertEquals((Object)"Ben", (Object)this.testUser.getFirstName());
        Assert.assertEquals((Object)"Bitdiddle", (Object)this.testUser.getLastName());
    }

    @Test
    public void testSamlAttributesReceivedForNonexistentUserWithAutoregisterDisabled() throws Exception {
        this.configurationService.setProperty("authentication-saml.autoregister", (Object)false);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/saml", (Object[])new Object[0]).requestAttr("org.dspace.saml.NAME_ID", (Object)"001").requestAttr("org.dspace.saml.EMAIL", (Object)"ben@dspace.org").requestAttr("org.dspace.saml.GIVEN_NAME", (Object)"Ben").requestAttr("org.dspace.saml.SURNAME", (Object)"Bitdiddle")).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie")).andExpect(MockMvcResultMatchers.header().exists("WWW-Authenticate")).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN")).andReturn();
    }

    private String getEPersonIdFromAuthorizationCookie(MvcResult mvcResult) throws ParseException, JOSEException {
        Cookie authorizationCookie = mvcResult.getResponse().getCookie("Authorization-cookie");
        SignedJWT jwt = SignedJWT.parse((String)authorizationCookie.getValue());
        return (String)jwt.getJWTClaimsSet().getClaim("eid");
    }
}

