/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.matcher.ScriptMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ProcessStatus;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.service.ProcessService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ScriptRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ProcessService processService;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private List<ScriptConfiguration> scriptConfigurations;
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;
    @Autowired
    private ObjectMapper mapper;

    @Test
    public void findAllScriptsTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.containsInAnyOrder((Collection)this.scriptConfigurations.stream().map(scriptConfiguration -> ScriptMatcher.matchScript(scriptConfiguration.getName(), scriptConfiguration.getDescription())).collect(Collectors.toList()))));
    }

    @Test
    public void findAllScriptsSortedAlphabeticallyTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0]).param("size", new String[]{String.valueOf(this.scriptConfigurations.size())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.contains(this.scriptConfigurations.stream().sorted(Comparator.comparing(ScriptConfiguration::getName)).map(scriptConfiguration -> ScriptMatcher.matchScript(scriptConfiguration.getName(), scriptConfiguration.getDescription())).collect(Collectors.toList()))));
    }

    @Test
    public void findAllScriptsGenericLoggedInUserTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findAllScriptsAnonymousUserTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllScriptsLocalAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson comAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin@example.com").withPassword(this.password).build();
        EPerson colAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin@example.com").withPassword(this.password).build();
        EPerson itemAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("itemAdmin@example.com").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withAdminGroup(new EPerson[]{comAdmin}).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withAdminGroup(new EPerson[]{colAdmin}).build();
        ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withAdminUser(itemAdmin).withTitle("Test item to curate").build();
        this.context.restoreAuthSystemState();
        ScriptConfiguration curateScriptConfiguration = this.scriptConfigurations.stream().filter(scriptConfiguration -> scriptConfiguration.getName().equals("curate")).findAny().get();
        String comAdminToken = this.getAuthToken(comAdmin.getEmail(), this.password);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0]).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.hasItem(ScriptMatcher.matchScript(curateScriptConfiguration.getName(), curateScriptConfiguration.getDescription())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        String colAdminToken = this.getAuthToken(colAdmin.getEmail(), this.password);
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0]).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.hasItem(ScriptMatcher.matchScript(curateScriptConfiguration.getName(), curateScriptConfiguration.getDescription())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        String itemAdminToken = this.getAuthToken(itemAdmin.getEmail(), this.password);
        this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0]).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.hasItem(ScriptMatcher.matchScript(curateScriptConfiguration.getName(), curateScriptConfiguration.getDescription())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
    }

    @Test
    public void findAllScriptsPaginationTest() throws Exception {
        List alphabeticScripts = this.scriptConfigurations.stream().sorted(Comparator.comparing(ScriptConfiguration::getName)).collect(Collectors.toList());
        int totalPages = this.scriptConfigurations.size();
        int lastPage = totalPages - 1;
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.not((Matcher)Matchers.hasItem(ScriptMatcher.matchScript(((ScriptConfiguration)alphabeticScripts.get(1)).getName(), ((ScriptConfiguration)alphabeticScripts.get(1)).getDescription()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.hasItem(ScriptMatcher.matchScript(((ScriptConfiguration)alphabeticScripts.get(0)).getName(), ((ScriptConfiguration)alphabeticScripts.get(0)).getDescription())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)("page=" + lastPage)), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalPages)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.hasItem(ScriptMatcher.matchScript(((ScriptConfiguration)alphabeticScripts.get(1)).getName(), ((ScriptConfiguration)alphabeticScripts.get(1)).getDescription())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.scripts", (Matcher)Matchers.not((Matcher)Matchers.hasItem(ScriptMatcher.matchScript(((ScriptConfiguration)alphabeticScripts.get(0)).getName(), ((ScriptConfiguration)alphabeticScripts.get(0)).getDescription()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/system/scripts?"), (Matcher)Matchers.containsString((String)("page=" + lastPage)), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalPages)));
    }

    @Test
    public void findOneScriptByNameTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts/mock-script", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ScriptMatcher.matchMockScript(this.scriptConfigurations.stream().filter(scriptConfiguration -> scriptConfiguration.getName().equals("mock-script")).findAny().orElseThrow().getOptions())));
    }

    @Test
    public void findOneScriptByNameLocalAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson comAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin@example.com").withPassword(this.password).build();
        EPerson colAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin@example.com").withPassword(this.password).build();
        EPerson itemAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("itemAdmin@example.com").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withAdminGroup(new EPerson[]{comAdmin}).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withAdminGroup(new EPerson[]{colAdmin}).build();
        ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withAdminUser(itemAdmin).withTitle("Test item to curate").build();
        this.context.restoreAuthSystemState();
        ScriptConfiguration curateScriptConfiguration = this.scriptConfigurations.stream().filter(scriptConfiguration -> scriptConfiguration.getName().equals("curate")).findAny().get();
        String comAdminToken = this.getAuthToken(comAdmin.getEmail(), this.password);
        String colAdminToken = this.getAuthToken(colAdmin.getEmail(), this.password);
        String itemAdminToken = this.getAuthToken(itemAdmin.getEmail(), this.password);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/scripts/" + curateScriptConfiguration.getName()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ScriptMatcher.matchScript(curateScriptConfiguration.getName(), curateScriptConfiguration.getDescription())));
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/scripts/" + curateScriptConfiguration.getName()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ScriptMatcher.matchScript(curateScriptConfiguration.getName(), curateScriptConfiguration.getDescription())));
        this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/scripts/" + curateScriptConfiguration.getName()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ScriptMatcher.matchScript(curateScriptConfiguration.getName(), curateScriptConfiguration.getDescription())));
    }

    @Test
    public void findOneScriptByNameNotAuthenticatedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts/mock-script", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneScriptByNameTestAccessDenied() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts/mock-script", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneScriptByInvalidNameBadRequestExceptionTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts/mock-script-invalid", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postProcessNonAdminAuthorizeException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson comAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin@example.com").withPassword(this.password).build();
        EPerson colAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin@example.com").withPassword(this.password).build();
        EPerson itemAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("itemAdmin@example.com").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withAdminGroup(new EPerson[]{comAdmin}).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withAdminGroup(new EPerson[]{colAdmin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withAdminUser(itemAdmin).withTitle("Test item to curate").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String comAdmin_token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String colAdmin_token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String itemAdmin_token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(comAdmin_token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(colAdmin_token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(itemAdmin_token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void postProcessAnonymousAuthorizeException() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void postProcessAdminWrongOptionsException() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("mock-script", String.valueOf(this.admin.getID()), new LinkedList<DSpaceCommandLineParameter>(), ProcessStatus.FAILED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postProcessAdminNoOptionsFailedStatus() throws Exception {
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-z", "test"));
        parameters.add(new DSpaceCommandLineParameter("-q", null));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0]).param("properties", new String[]{this.mapper.writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("mock-script", String.valueOf(this.admin.getID()), parameters, ProcessStatus.FAILED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void postProcessNonExistingScriptNameException() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script-invalid/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postProcessAdminWithOptionsSuccess() throws Exception {
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-r", "test"));
        parameters.add(new DSpaceCommandLineParameter("-i", null));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<ProcessStatus> acceptableProcessStatuses = new LinkedList<ProcessStatus>();
        acceptableProcessStatuses.addAll(Arrays.asList(ProcessStatus.SCHEDULED, ProcessStatus.RUNNING, ProcessStatus.COMPLETED));
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0]).param("properties", new String[]{this.mapper.writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("mock-script", String.valueOf(this.admin.getID()), parameters, acceptableProcessStatuses)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postProcessAndVerifyOutput() throws Exception {
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-r", "test"));
        parameters.add(new DSpaceCommandLineParameter("-i", null));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<ProcessStatus> acceptableProcessStatuses = new LinkedList<ProcessStatus>();
        acceptableProcessStatuses.addAll(Arrays.asList(ProcessStatus.SCHEDULED, ProcessStatus.RUNNING, ProcessStatus.COMPLETED));
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0]).param("properties", new String[]{this.mapper.writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("mock-script", String.valueOf(this.admin.getID()), parameters, acceptableProcessStatuses)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            Process process = this.processService.find(this.context, ((Integer)idRef.get()).intValue());
            Bitstream bitstream = this.processService.getBitstream(this.context, process, "script_output");
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/processes/" + idRef.get() + "/output"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchBitstreamEntryWithoutEmbed(bitstream.getID(), bitstream.getSizeBytes())));
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)("INFO mock-script - " + process.getID() + " @ The script has started")));
            Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)("INFO mock-script - " + process.getID() + " @ Logging INFO for Mock DSpace Script")));
            Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)("ERROR mock-script - " + process.getID() + " @ Logging ERROR for Mock DSpace Script")));
            Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)("WARNING mock-script - " + process.getID() + " @ Logging WARNING for Mock DSpace Script")));
            Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)("INFO mock-script - " + process.getID() + " @ The script has completed")));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void postProcessAdminWithWrongContentTypeBadRequestException() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/system/scripts/mock-script-invalid/processes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postProcessAdminWithFileSuccess() throws Exception {
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-r", "test"));
        parameters.add(new DSpaceCommandLineParameter("-i", null));
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        org.dspace.content.Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "Hello, World!";
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "helloProcessFile.txt", "text/plain", bitstreamContent.getBytes());
        parameters.add(new DSpaceCommandLineParameter("-f", "helloProcessFile.txt"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<ProcessStatus> acceptableProcessStatuses = new LinkedList<ProcessStatus>();
        acceptableProcessStatuses.addAll(Arrays.asList(ProcessStatus.SCHEDULED, ProcessStatus.RUNNING, ProcessStatus.COMPLETED));
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0]).file(bitstreamFile).characterEncoding("UTF-8").param("properties", new String[]{this.mapper.writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("mock-script", String.valueOf(this.admin.getID()), parameters, acceptableProcessStatuses)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void scriptTypeConversionTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/scripts/type-conversion-test", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ScriptMatcher.matchScript("type-conversion-test", "Test the type conversion different option types"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.parameters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"-b")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)"option set to the boolean class")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"boolean")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.mandatory", (Matcher)Matchers.is((Object)false)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.nameLong", (Matcher)Matchers.is((Object)"--boolean"))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"-s")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)"string option with an argument")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"String")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.mandatory", (Matcher)Matchers.is((Object)false)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.nameLong", (Matcher)Matchers.is((Object)"--string"))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"-n")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)"string option without an argument")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"boolean")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.mandatory", (Matcher)Matchers.is((Object)false)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.nameLong", (Matcher)Matchers.is((Object)"--noargument"))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"-f")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)"file option with an argument")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"InputStream")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.mandatory", (Matcher)Matchers.is((Object)false)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.nameLong", (Matcher)Matchers.is((Object)"--file")))})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TrackSpecialGroupduringprocessSchedulingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group specialGroup = GroupBuilder.createGroup((Context)this.context).withName("Special Group").addMember(this.admin).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("authentication-password.login.specialgroup", (Object)specialGroup.getName());
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-r", "test"));
        parameters.add(new DSpaceCommandLineParameter("-i", null));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<ProcessStatus> acceptableProcessStatuses = new LinkedList<ProcessStatus>();
        acceptableProcessStatuses.addAll(Arrays.asList(ProcessStatus.SCHEDULED, ProcessStatus.RUNNING, ProcessStatus.COMPLETED));
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/system/scripts/mock-script/processes", (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{this.mapper.writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("mock-script", String.valueOf(this.admin.getID()), parameters, acceptableProcessStatuses)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            Process process = this.processService.find(this.context, ((Integer)idRef.get()).intValue());
            List groups = process.getGroups();
            boolean isPresent = groups.stream().anyMatch(g -> g.getID().equals(specialGroup.getID()));
            Assert.assertTrue((boolean)isPresent);
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    @After
    public void destroy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CollectionUtils.emptyIfNull((Collection)this.processService.findAll(this.context)).stream().forEach(process -> {
            try {
                this.processService.delete(this.context, process);
            }
            catch (IOException | SQLException | AuthorizeException e) {
                throw new RuntimeException(e);
            }
        });
        this.context.restoreAuthSystemState();
        super.destroy();
    }
}

