/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.UUID;
import org.dspace.app.rest.matcher.AccessConditionOptionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmissionAccessOptionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAllTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionaccessoptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneByAdminTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionaccessoptions/defaultAC", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"defaultAC"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canChangeDiscoverable", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.accessConditionOptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AccessConditionOptionMatcher.matchAccessConditionOption("openaccess", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("embargo", true, false, "+36MONTHS", null), AccessConditionOptionMatcher.matchAccessConditionOption("administrator", false, false, null, null)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionaccessoption")));
    }

    @Test
    public void findOneByNormalUsreTest() throws Exception {
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionaccessoptions/defaultAC", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"defaultAC"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canChangeDiscoverable", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.accessConditionOptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AccessConditionOptionMatcher.matchAccessConditionOption("openaccess", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("embargo", true, false, "+36MONTHS", null), AccessConditionOptionMatcher.matchAccessConditionOption("administrator", false, false, null, null)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionaccessoption")));
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionaccessoptions/defaultAC", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneCanNotChangeDiscoverableTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionaccessoptions/notDiscoverable", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"notDiscoverable"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canChangeDiscoverable", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.accessConditionOptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AccessConditionOptionMatcher.matchAccessConditionOption("embargo", true, false, "+36MONTHS", null), AccessConditionOptionMatcher.matchAccessConditionOption("administrator", false, false, null, null)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionaccessoption")));
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/submissionaccessoptions/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

