/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.List;
import org.dspace.app.rest.matcher.SubmissionCOARNotifyMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.coarnotify.NotifyPattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmissionCOARNotifyRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAllTestUnAuthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncoarnotifyconfigs", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncoarnotifyconfigs", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissioncoarnotifyconfigs", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubmissionCOARNotifyMatcher.matchCOARNotifyEntry("coarnotify", List.of(new NotifyPattern("request-review", true), new NotifyPattern("request-endorsement", true), new NotifyPattern("request-ingest", false)))})));
    }

    @Test
    public void findOneTestUnAuthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncoarnotifyconfigs/coarnotify", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneTestNonExistingCOARNotify() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncoarnotifyconfigs/non-existing-coar", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncoarnotifyconfigs/coarnotify", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(SubmissionCOARNotifyMatcher.matchCOARNotifyEntry("coarnotify", List.of(new NotifyPattern("request-review", true), new NotifyPattern("request-endorsement", true), new NotifyPattern("request-ingest", false))))));
    }
}

