/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.List;
import org.dspace.app.rest.matcher.SubmissionDefinitionsMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmissionDefinitionsControllerIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAll() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.search.href", (Matcher)Matchers.is((Object)"http://localhost/api/config/submissiondefinitions/search"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))));
    }

    @Test
    public void findAllWithNewlyCreatedAccountTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.search.href", (Matcher)Matchers.is((Object)"http://localhost/api/config/submissiondefinitions/search"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))));
    }

    @Test
    public void findDefault() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/traditional", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/traditional", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SubmissionDefinitionsMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SubmissionDefinitionsMatcher.matchLinks("traditional"))).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SubmissionDefinitionsMatcher.matchSubmissionDefinition(true, "traditional", "traditional")));
    }

    @Test
    public void findOneWithNewlyCreatedAccountTest() throws Exception {
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/traditional", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.isDefault", (Matcher)Matchers.is((Object)true)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"traditional")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditional")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissiondefinition")))));
    }

    @Test
    public void findByCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/search/findByCollection", (Object[])new Object[0]).param("uuid", new String[]{col1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/search/findByCollection", (Object[])new Object[0]).param("uuid", new String[]{col1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SubmissionDefinitionsMatcher.matchSubmissionDefinition(true, "traditional", "traditional")));
    }

    @Test
    public void findByCollectionWithNewlyCreatedAccountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/search/findByCollection", (Object[])new Object[0]).param("uuid", new String[]{col1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SubmissionDefinitionsMatcher.matchSubmissionDefinition(true, "traditional", "traditional")));
    }

    @Test
    public void findCollections() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/traditional/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/traditional/collections", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findSections() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/traditional/sections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/traditional/sections", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionsections", (Matcher)Matchers.hasSize((int)10))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionsections", (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditionalpageone")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sectionType", (Matcher)Matchers.is((Object)"submission-form")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionsection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.config.href", (Matcher)Matchers.is((Object)"http://localhost/api/config/submissionforms/traditionalpageone")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.is((Object)"http://localhost/api/config/submissionsections/traditionalpageone"))))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions/extractiontestprocess/sections", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionsections", (Matcher)Matchers.hasSize((int)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionsections", (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"extractionstep"))))));
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        List definitions = new SubmissionConfigReader().getAllSubmissionConfigs(Integer.valueOf(100), Integer.valueOf(0));
        int totalDefinitions = definitions.size();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"0"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions[0]", SubmissionDefinitionsMatcher.matchSubmissionConfig((SubmissionConfig)definitions.get(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions[0]", SubmissionDefinitionsMatcher.matchSubmissionConfig((SubmissionConfig)definitions.get(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions[0]", SubmissionDefinitionsMatcher.matchSubmissionConfig((SubmissionConfig)definitions.get(2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"3"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions[0]", SubmissionDefinitionsMatcher.matchSubmissionConfig((SubmissionConfig)definitions.get(3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=4"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"4"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions[0]", SubmissionDefinitionsMatcher.matchSubmissionConfig((SubmissionConfig)definitions.get(4)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=5"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=4"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)4)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions[0]", SubmissionDefinitionsMatcher.matchSubmissionConfig((SubmissionConfig)definitions.get(5)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=4"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=6"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=5"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)5)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissiondefinitions", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"" + (totalDefinitions - 1)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissiondefinitions[0]", SubmissionDefinitionsMatcher.matchSubmissionConfig((SubmissionConfig)definitions.get(totalDefinitions - 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 2))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissiondefinitions?"), (Matcher)Matchers.containsString((String)("page=" + (totalDefinitions - 1))), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)totalDefinitions))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)(totalDefinitions - 1))));
    }
}

