/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.SubscriptionMatcher;
import org.dspace.app.rest.model.SubscriptionParameterRest;
import org.dspace.app.rest.model.SubscriptionRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.SubscribeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.SubscriptionParameter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubscriptionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    @Autowired
    private ObjectMapper mapper;
    private Community subCommunity;
    private Collection collection;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.subCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Test Sub Community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAll() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription1 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        ArrayList<SubscriptionParameter> subscriptionParameterList2 = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter2 = new SubscriptionParameter();
        subscriptionParameter2.setName("frequency");
        subscriptionParameter2.setValue("W");
        subscriptionParameterList2.add(subscriptionParameter2);
        Subscription subscription2 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList2).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subscriptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubscriptionMatcher.matchSubscription(subscription1), SubscriptionMatcher.matchSubscription(subscription2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findAllAnonymous() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllAsUser() throws Exception {
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneWithOwnerTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("M");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionType", (Matcher)Matchers.is((Object)"content"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].name", (Matcher)Matchers.is((Object)"frequency"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].value", (Matcher)Matchers.is((Object)"M"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.endsWith((String)"/eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.endsWith((String)"/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)("http://localhost/api/core/subscriptions/" + subscription.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/core/subscriptions"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/core/subscriptions")));
    }

    @Test
    public void findOneAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("W");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionType", (Matcher)Matchers.is((Object)"content"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].name", (Matcher)Matchers.is((Object)"frequency"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].value", (Matcher)Matchers.is((Object)"W"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)("http://localhost/api/core/subscriptions/" + subscription.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/core/subscriptions"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.endsWith((String)"/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/core/subscriptions"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.endsWith((String)"/eperson")));
    }

    @Test
    public void findOneAnonymousTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("W");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findSubscriptionsByEPersonAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription1 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        ArrayList<SubscriptionParameter> subscriptionParameterList2 = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter2 = new SubscriptionParameter();
        subscriptionParameter2.setName("frequency");
        subscriptionParameter2.setValue("W");
        subscriptionParameterList2.add(subscriptionParameter2);
        Subscription subscription2 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList2).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPerson", (Object[])new Object[0]).param("uuid", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subscriptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubscriptionMatcher.matchSubscription(subscription1), SubscriptionMatcher.matchSubscription(subscription2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findSubscriptionsByEPersonOwnerTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("M");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription1 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        ArrayList<SubscriptionParameter> subscriptionParameterList2 = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter2 = new SubscriptionParameter();
        subscriptionParameter2.setName("frequency");
        subscriptionParameter2.setValue("D");
        subscriptionParameterList2.add(subscriptionParameter2);
        Subscription subscription2 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList2).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPerson", (Object[])new Object[0]).param("uuid", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subscriptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubscriptionMatcher.matchSubscription(subscription1), SubscriptionMatcher.matchSubscription(subscription2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findSubscriptionsByEPersonUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPerson", (Object[])new Object[0]).param("uuid", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findSubscriptionsByEPersonForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withEmail("user1@mail.com").withPassword(this.password).build();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)user, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPerson", (Object[])new Object[0]).param("uuid", new String[]{user.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByEPersonAndDsoAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription1 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        ArrayList<SubscriptionParameter> subscriptionParameterList2 = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter2 = new SubscriptionParameter();
        subscriptionParameter2.setName("frequency");
        subscriptionParameter2.setValue("W");
        subscriptionParameterList2.add(subscriptionParameter2);
        Subscription subscription2 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList2).build();
        ArrayList<SubscriptionParameter> subscriptionParameterList3 = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter3 = new SubscriptionParameter();
        subscriptionParameter3.setName("frequency");
        subscriptionParameter3.setValue("M");
        subscriptionParameterList3.add(subscriptionParameter3);
        Subscription subscription3 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.subCommunity, (EPerson)this.eperson, subscriptionParameterList3).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPersonAndDso", (Object[])new Object[0]).param("eperson_id", new String[]{this.eperson.getID().toString()}).param("resource", new String[]{this.collection.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subscriptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubscriptionMatcher.matchSubscription(subscription1), SubscriptionMatcher.matchSubscription(subscription2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPersonAndDso", (Object[])new Object[0]).param("eperson_id", new String[]{this.eperson.getID().toString()}).param("resource", new String[]{this.subCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subscriptions", (Matcher)Matchers.contains(SubscriptionMatcher.matchSubscription(subscription3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByEPersonAndDsoOwnerTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription1 = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.subCommunity, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPersonAndDso", (Object[])new Object[0]).param("eperson_id", new String[]{this.eperson.getID().toString()}).param("resource", new String[]{this.subCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subscriptions", (Matcher)Matchers.contains(SubscriptionMatcher.matchSubscription(subscription1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByEPersonAndDsoUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.subCommunity, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPersonAndDso", (Object[])new Object[0]).param("eperson_id", new String[]{this.eperson.getID().toString()}).param("resource", new String[]{this.subCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByEPersonAndDsoForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.subCommunity, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/search/findByEPersonAndDso", (Object[])new Object[0]).param("eperson_id", new String[]{this.admin.getID().toString()}).param("resource", new String[]{this.subCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createSubscriptionUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SubscriptionParameterRest subscriptionParameterRest = new SubscriptionParameterRest();
        subscriptionParameterRest.setValue("frequency");
        subscriptionParameterRest.setName("D");
        ArrayList<SubscriptionParameterRest> subscriptionParameterRestList = new ArrayList<SubscriptionParameterRest>();
        subscriptionParameterRestList.add(subscriptionParameterRest);
        SubscriptionRest subscriptionRest = new SubscriptionRest();
        subscriptionRest.setSubscriptionType("content");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString((Object)subscriptionRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSubscriptionAdminForOtherPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "D");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionType", (Matcher)Matchers.is((Object)"content"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].name", (Matcher)Matchers.is((Object)"frequency"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].value", (Matcher)Matchers.is((Object)"D"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.endsWith((String)"eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.endsWith((String)"resource"))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            SubscribeBuilder.deleteSubscription((int)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSubscriptionByEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionType", (Matcher)Matchers.is((Object)"content"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].name", (Matcher)Matchers.is((Object)"frequency"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].value", (Matcher)Matchers.is((Object)"W"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.endsWith((String)"eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.endsWith((String)"resource"))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            SubscribeBuilder.deleteSubscription((int)((Integer)idRef.get()));
        }
    }

    @Test
    public void createSubscriptionForItemByEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Public item").build();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{item1.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createSubscriptionForItemByAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Public item").build();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{item1.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createSubscriptionWrongResourceUUIDTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{UUID.randomUUID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createSubscriptionMissingResourceUUIDTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createSubscriptionWithWrongSubscriptionParameterNameTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "TestName");
        sub_list.put("value", "X");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createSubscriptionWithInvalidSubscriptionParameterValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "X");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createSubscriptionWithInvalidSubscriptionTypeValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "InvalidValue");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createSubscriptionInvalidJsonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "daily");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{this.eperson.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createSubscriptionPersonForAnotherPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withEmail("user1@mail.com").withPassword(this.password).build();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "D");
        list.add(sub_list);
        map.put("subscriptionParameterList", list);
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/subscriptions", (Object[])new Object[0]).param("resource", new String[]{this.collection.getID().toString()}).param("eperson_id", new String[]{user.getID().toString()}).content(this.mapper.writeValueAsString(map)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteSubscriptionUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteSubscriptionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteSubscriptionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteSubscriptionNotFoundTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/core/subscriptions/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void putSubscriptionUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("Parameter1");
        subscriptionParameter.setValue("ValueParameter1");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        HashMap<String, Object> newSubscription = new HashMap<String, Object>();
        newSubscription.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "daily");
        list.add(sub_list);
        newSubscription.put("subscriptionParameterList", list);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsString(newSubscription)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void putSubscriptionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        HashMap<String, Object> newSubscription = new HashMap<String, Object>();
        newSubscription.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        newSubscription.put("subscriptionParameterList", list);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsString(newSubscription)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void putSubscriptionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        HashMap<String, Object> newSubscription = new HashMap<String, Object>();
        newSubscription.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        newSubscription.put("subscriptionParameterList", list);
        String tokenSubscriber = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenSubscriber).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsString(newSubscription)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionType", (Matcher)Matchers.is((Object)"content"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].name", (Matcher)Matchers.is((Object)"frequency"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].value", (Matcher)Matchers.is((Object)"W"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.endsWith((String)"/eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.endsWith((String)"/resource")));
    }

    @Test
    public void putSubscriptionInvalidSubscriptionParameterNameTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        HashMap<String, Object> newSubscription = new HashMap<String, Object>();
        newSubscription.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "InvalidName");
        sub_list.put("value", "W");
        list.add(sub_list);
        newSubscription.put("subscriptionParameterList", list);
        String tokenSubscriber = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenSubscriber).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsString(newSubscription)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void putSubscriptionInvalidSubscriptionParameterValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        HashMap<String, Object> newSubscription = new HashMap<String, Object>();
        newSubscription.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "Y");
        list.add(sub_list);
        newSubscription.put("subscriptionParameterList", list);
        String tokenSubscriber = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenSubscriber).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsString(newSubscription)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void putSubscriptionInvalidSubscriptionTypeValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        HashMap<String, Object> newSubscription = new HashMap<String, Object>();
        newSubscription.put("subscriptionType", "InvalidType");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "D");
        list.add(sub_list);
        newSubscription.put("subscriptionParameterList", list);
        String tokenSubscriber = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenSubscriber).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsString(newSubscription)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void putSubscriptionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        HashMap<String, Object> newSubscription = new HashMap<String, Object>();
        newSubscription.put("subscriptionType", "content");
        ArrayList list = new ArrayList();
        HashMap<String, String> sub_list = new HashMap<String, String>();
        sub_list.put("name", "frequency");
        sub_list.put("value", "W");
        list.add(sub_list);
        newSubscription.put("subscriptionParameterList", list);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/subscriptions/" + subscription.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsString(newSubscription)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionType", (Matcher)Matchers.is((Object)"content"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].name", (Matcher)Matchers.is((Object)"frequency"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.subscriptionParameterList[0].value", (Matcher)Matchers.is((Object)"W"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.endsWith((String)"/eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.endsWith((String)"/resource")));
    }

    @Test
    public void linkedEpersonOfSubscriptionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("M");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/eperson"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(this.eperson))));
    }

    @Test
    public void linkedEpersonOfSubscriptionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("M");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/eperson"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(this.eperson))));
    }

    @Test
    public void linkedEpersonOfSubscriptionUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("M");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/eperson"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void linkedEpersonOfSubscriptionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("W");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/eperson"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void linkedEpersonOfSubscriptionNotFoundTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/2147483647/eperson", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void linkedDSpaceObjectOfSubscriptionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("W");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/resource"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)this.collection.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)this.collection.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")));
    }

    @Test
    public void linkedDSpaceObjectOfSubscriptionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("W");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/resource"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)this.collection.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)this.collection.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")));
    }

    @Test
    public void linkedDSpaceObjectOfSubscriptionUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("W");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/resource"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void linkedDSpaceObjectOfSubscriptionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)this.collection, (EPerson)this.admin, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/resource"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void linkedDSpaceObjectAndRestrictedAccessAfterYouHaveSubscriptionToItTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1 Test").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        ArrayList<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();
        SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
        subscriptionParameter.setName("frequency");
        subscriptionParameter.setValue("D");
        subscriptionParameterList.add(subscriptionParameter);
        Subscription subscription = SubscribeBuilder.subscribeBuilder((Context)this.context, (String)"content", (DSpaceObject)col1, (EPerson)this.eperson, subscriptionParameterList).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/resource"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)col1.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")));
        this.context.turnOffAuthorisationSystem();
        this.resourcePolicyService.removeAllPolicies(this.context, (DSpaceObject)col1);
        this.context.restoreAuthSystemState();
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/subscriptions/" + subscription.getID() + "/resource"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void linkedDSpaceObjectOfSubscriptionNotFoundTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/subscriptions/2147483647/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

