/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.SuggestionSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.SuggestionTargetBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SuggestionSourceRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private Collection colPeople;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.colPeople = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("People").withEntityType("Person").build();
        this.context.restoreAuthSystemState();
    }

    private void buildSuggestionTargetsList() {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetSecond = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        for (int idx = 0; idx < 8; ++idx) {
            Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Test " + idx).build();
            SuggestionTargetBuilder.createTarget((Context)this.context, (Item)item).withSuggestionCount("reciter", idx + 3).build();
            if (idx % 3 != 0) continue;
            SuggestionTargetBuilder.createTarget((Context)this.context, (Item)item).withSuggestionCount("scopus", idx + 7).build();
        }
        Item itemLast = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Lombardi, Corrado").build();
        SuggestionTarget targetLast = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemLast).withSuggestionCount("scopus", 3).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllTest() throws Exception {
        this.buildSuggestionTargetsList();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestionsources", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SuggestionSourceMatcher.matchSuggestionSource("reciter", 10), SuggestionSourceMatcher.matchSuggestionSource("scopus", 5)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        this.buildSuggestionTargetsList();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources", (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestionsources", (Matcher)Matchers.contains(SuggestionSourceMatcher.matchSuggestionSource("reciter", 10)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/integration/suggestionsources"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestionsources?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestionsources?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestionsources?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestionsources", (Matcher)Matchers.contains(SuggestionSourceMatcher.matchSuggestionSource("scopus", 5)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/integration/suggestionsources"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestionsources?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestionsources?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestionsources?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAllNotAdminTest() throws Exception {
        this.buildSuggestionTargetsList();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneTest() throws Exception {
        this.buildSuggestionTargetsList();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources/reciter", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionSourceMatcher.matchSuggestionSource("reciter", 10))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/integration/suggestionsources/reciter")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources/scopus", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionSourceMatcher.matchSuggestionSource("scopus", 5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/integration/suggestionsources/scopus")));
    }

    @Test
    public void findOneNotAdminTest() throws Exception {
        this.buildSuggestionTargetsList();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources/reciter", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources/not-exist", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources/reciter", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestionsources/not-exist", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

