/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanSendFeedbackFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SiteService siteService;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    final String feature = "canSendFeedback";
    private AuthorizationFeature canSendFeedbackFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.canSendFeedbackFeature = this.authorizationFeatureService.find("canSendFeedback");
    }

    @Test
    public void canSendFeedbackFeatureTest() throws Exception {
        this.configurationService.setProperty("feedback.recipient", (Object)"myemail@test.com");
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        Authorization authAdminSite = new Authorization(this.admin, this.canSendFeedbackFeature, (BaseObjectRest)siteRest);
        Authorization authAnonymousSite = new Authorization(null, this.canSendFeedbackFeature, (BaseObjectRest)siteRest);
        Authorization authEPersonSite = new Authorization(this.eperson, this.canSendFeedbackFeature, (BaseObjectRest)siteRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSite))));
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEPersonSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authEPersonSite))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAnonymousSite))));
    }

    @Test
    public void canSendFeedbackFeatureWithRecipientEmailNotConfiguredTest() throws Exception {
        this.configurationService.setProperty("feedback.recipient", null);
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        Authorization authAdminSite = new Authorization(this.admin, this.canSendFeedbackFeature, (BaseObjectRest)siteRest);
        Authorization authAnonymousSite = new Authorization(null, this.canSendFeedbackFeature, (BaseObjectRest)siteRest);
        Authorization authEPersonSite = new Authorization(this.eperson, this.canSendFeedbackFeature, (BaseObjectRest)siteRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEPersonSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

