/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CommunityAdminFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SiteService siteService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private GroupService groupService;
    private Community topLevelCommunityA;
    private Community subCommunityA;
    private Collection collectionA;
    private EPerson topLevelCommunityAAdmin;
    private EPerson subCommunityAAdmin;
    private EPerson collectionAdmin;
    private EPerson submitter;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.topLevelCommunityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("topLevelCommunityAAdmin@my.edu").withPassword(this.password).build();
        this.topLevelCommunityA = CommunityBuilder.createCommunity((Context)this.context).withName("The name of this community is topLevelCommunityA").withAdminGroup(new EPerson[]{this.topLevelCommunityAAdmin}).build();
        this.subCommunityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("subCommunityAAdmin@my.edu").withPassword(this.password).build();
        this.subCommunityA = CommunityBuilder.createCommunity((Context)this.context).withName("The name of this sub-community is subCommunityA").withAdminGroup(new EPerson[]{this.subCommunityAAdmin}).addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.submitter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("submitter@my.edu").withPassword(this.password).build();
        this.collectionAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionAdmin@my.edu").withPassword(this.password).build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityA).withName("The name of this collection is collectionA").withAdminGroup(new EPerson[]{this.collectionAdmin}).withSubmitterGroup(new EPerson[]{this.submitter}).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)"true");
    }

    @Test
    public void testAdmin() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCommunityAdmin() throws Exception {
        String token = this.getAuthToken(this.topLevelCommunityAAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubCommunityAdmin() throws Exception {
        String token = this.getAuthToken(this.subCommunityAAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCollectionAdmin() throws Exception {
        String token = this.getAuthToken(this.collectionAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubmitter() throws Exception {
        String token = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "Administrator")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunityA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfSubCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunityA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCollectionAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubmitterGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_SUBMIT")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "Administrator")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunityA.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfSubCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunityA.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCollectionAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfSubmitterGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_SUBMIT")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='isCommunityAdmin')]", (Object[])new Object[0]).doesNotExist());
    }
}

