/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EPersonForgotPasswordFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private SiteService siteService;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private EPersonConverter personConverter;
    @Autowired
    private Utils utils;
    private AuthorizationFeature epersonForgotPasswordFeature;
    public static final String[] SHIB_ONLY = new String[]{"org.dspace.authenticate.ShibAuthentication"};

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.epersonForgotPasswordFeature = this.authorizationFeatureService.find("epersonForgotPassword");
    }

    @Test
    public void userForgotPasswordSuccessTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson epersonPassLogin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Vincenzo", "Mecca").withCanLogin(true).withPassword("Strong-Password").withEmail("vincenzo.mecca@4science.it").build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("user.forgot-password", (Object)true);
        EPersonRest personRest = this.personConverter.convert(epersonPassLogin, Projection.DEFAULT);
        String personUri = this.utils.linkToSingleResource((RestAddressableModel)personRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{personUri}).param("feature", new String[]{this.epersonForgotPasswordFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void userForgotPasswordFeatureUnauthorizedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest SiteRest2 = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)SiteRest2, "self").getHref();
        this.configurationService.setProperty("user.forgot-password", (Object)false);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.epersonForgotPasswordFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void userForgotPasswordNoLoginTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson noLoginPerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("User", "NoLogin").withCanLogin(false).withPassword("Strong-Password").build();
        this.context.restoreAuthSystemState();
        EPersonRest personRest = this.personConverter.convert(noLoginPerson, Projection.DEFAULT);
        String personUri = this.utils.linkToSingleResource((RestAddressableModel)personRest, "self").getHref();
        this.configurationService.setProperty("user.forgot-password", (Object)true);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{personUri}).param("feature", new String[]{this.epersonForgotPasswordFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void userForgotPasswordUnauthorizedNoPasswordAuthMethodTest() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        EPersonRest personRest = this.personConverter.convert(this.eperson, Projection.DEFAULT);
        String personUri = this.utils.linkToSingleResource((RestAddressableModel)personRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{personUri}).param("feature", new String[]{this.epersonForgotPasswordFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }
}

