/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class QAAuthorizationFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private SiteService siteService;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private ConfigurationService configurationService;
    private AuthorizationFeature qaAuthorizationFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.qaAuthorizationFeature = this.authorizationFeatureService.find("canSeeQA");
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testQAAuthorizationSuccess() throws Exception {
        this.configurationService.setProperty("qaevents.enabled", (Object)true);
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization authAdminSite = new Authorization(this.admin, this.qaAuthorizationFeature, (BaseObjectRest)siteRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSite))));
    }

    @Test
    public void testQAAuthorizationFail() throws Exception {
        this.configurationService.setProperty("qaevents.enabled", (Object)false);
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization authAdminSite = new Authorization(this.admin, this.qaAuthorizationFeature, (BaseObjectRest)siteRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

