/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ReinstateFeatureRestIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private Utils utils;
    private AuthorizationFeature reinstateFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.reinstateFeature = this.authorizationFeatureService.find("reinstateItem");
    }

    @Test
    public void authorizedAsAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Withdrawn item").withdrawn().build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authAdminWithdraw = new Authorization(this.admin, this.reinstateFeature, (BaseObjectRest)itemRest);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.admin.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw)))));
    }

    @Test
    public void checkAuthorizationAsCommunityAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").withAdminGroup(new EPerson[]{this.eperson}).build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Withdrawn item").withdrawn().build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authAdminWithdraw = new Authorization(this.eperson, this.reinstateFeature, (BaseObjectRest)itemRest);
        String comAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw))));
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw)))));
        this.configurationService.setProperty("core.authorization.collection-admin.item.reinstate", (Object)false);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw))));
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw)))));
        this.configurationService.setProperty("core.authorization.community-admin.item.reinstate", (Object)false);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void checkAuthorizationAsCollectionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Withdrawn item").withdrawn().build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authAdminWithdraw = new Authorization(this.eperson, this.reinstateFeature, (BaseObjectRest)itemRest);
        String colAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw))));
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminWithdraw)))));
        this.configurationService.setProperty("core.authorization.collection-admin.item.reinstate", (Object)false);
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void notAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Withdrawn item").withdrawn().build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authEpersonWithdraw = new Authorization(this.eperson, this.reinstateFeature, (BaseObjectRest)itemRest);
        Authorization authAnonymousWithdraw = new Authorization(null, this.reinstateFeature, (BaseObjectRest)itemRest);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEpersonWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousWithdraw.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void notAuthorizedInvalidStateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").withWorkflowGroup(1, new EPerson[]{this.eperson}).build();
        Item archivedItem = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Item already in archive").build();
        WorkspaceItem wsItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col).withTitle("A workspace item").build();
        XmlWorkflowItem wfItem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col).withTitle("A workflow item").build();
        this.context.restoreAuthSystemState();
        ItemRest archivedItemRest = this.itemConverter.convert(archivedItem, Projection.DEFAULT);
        String archivedItemUri = this.utils.linkToSingleResource((RestAddressableModel)archivedItemRest, "self").getHref();
        ItemRest wsItemRest = this.itemConverter.convert(wsItem.getItem(), Projection.DEFAULT);
        String wsItemUri = this.utils.linkToSingleResource((RestAddressableModel)wsItemRest, "self").getHref();
        ItemRest wfItemRest = this.itemConverter.convert(wfItem.getItem(), Projection.DEFAULT);
        String wfItemUri = this.utils.linkToSingleResource((RestAddressableModel)wfItemRest, "self").getHref();
        Authorization authWithdrawnItem = new Authorization(this.admin, this.reinstateFeature, (BaseObjectRest)archivedItemRest);
        Authorization authWsItem = new Authorization(this.admin, this.reinstateFeature, (BaseObjectRest)wsItemRest);
        Authorization authWFItem = new Authorization(this.admin, this.reinstateFeature, (BaseObjectRest)wfItemRest);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authWithdrawnItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{archivedItemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authWsItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wsItemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authWFItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wfItemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.reinstateFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }
}

