/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dspace.app.rest.matcher.ParameterValueMatcher;
import org.dspace.content.ProcessStatus;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ProcessMatcher {
    private ProcessMatcher() {
    }

    private static Matcher<? super Object> matchProcess(String name, String userId) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.scriptName", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.userId", (Matcher)Matchers.is((Object)userId)));
    }

    public static Matcher<? super Object> matchProcess(String name, String userId, Integer processId, List<DSpaceCommandLineParameter> list, ProcessStatus status) {
        return Matchers.allOf(ProcessMatcher.matchProcess(name, userId, list, Collections.singletonList(status)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.processId", (Matcher)Matchers.is((Object)processId)));
    }

    public static Matcher<? super Object> matchProcess(String name, String userId, List<DSpaceCommandLineParameter> list, ProcessStatus status) {
        return Matchers.allOf((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(name, userId, list, Collections.singletonList(status))});
    }

    public static Matcher<? super Object> matchProcess(String name, String userId, List<DSpaceCommandLineParameter> list, List<ProcessStatus> statuses) {
        return Matchers.allOf((Matcher[])new Matcher[]{ProcessMatcher.matchProcess(name, userId), JsonPathMatchers.hasJsonPath((String)"$.startTime", (Matcher)Matchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue())), JsonPathMatchers.hasJsonPath((String)"$.endTime", (Matcher)Matchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue())), JsonPathMatchers.hasJsonPath((String)"$.processStatus", (Matcher)Matchers.anyOf((Iterable)statuses.stream().map(status -> Matchers.is((Object)status.toString())).collect(Collectors.toList()))), JsonPathMatchers.hasJsonPath((String)"$.parameters", (Matcher)Matchers.containsInAnyOrder((Collection)list.stream().map(dSpaceCommandLineParameter -> ParameterValueMatcher.matchParameterValue(dSpaceCommandLineParameter.getName(), dSpaceCommandLineParameter.getValue())).collect(Collectors.toList()))), JsonPathMatchers.hasJsonPath((String)"$._links.script.href", (Matcher)Matchers.containsString((String)name)), JsonPathMatchers.hasJsonPath((String)"$._links.files.href", (Matcher)Matchers.containsString((String)"files")), JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/system/processes"))});
    }
}

