/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.Collection;
import java.util.stream.Collectors;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.eperson.Subscription;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class SubscriptionMatcher {
    private SubscriptionMatcher() {
    }

    public static Matcher<? super Object> matchSubscription(Subscription subscription) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)subscription.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"subscription")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.subscriptionType", (Matcher)Matchers.is((Object)subscription.getSubscriptionType())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.subscriptionParameterList", (Matcher)Matchers.containsInAnyOrder((Collection)subscription.getSubscriptionParameterList().stream().map(x -> SubscriptionMatcher.matchSubscriptionParameter(x.getName(), x.getValue())).collect(Collectors.toList()))), SubscriptionMatcher.matchLinks(subscription.getID()));
    }

    public static Matcher<? super Object> matchSubscriptionParameter(String name, String value) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)value)));
    }

    public static Matcher<? super Object> matchLinks(Integer id) {
        return HalMatcher.matchLinks("http://localhost/api/core/subscriptions/" + id, "resource", "eperson", "self");
    }
}

