/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.orcid;

import org.dspace.app.rest.matcher.OrcidQueueMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.OrcidQueueBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidQueue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OrcidQueueRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ItemService itemService;

    @Test
    public void findAllTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidqueues", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findByProfileItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        EPerson researcher2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Laura", "Shulz").withEmail("laura.shulz@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withName("Collection 3").build();
        Item itemPerson = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        Item itemPerson2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Laura").withPersonIdentifierLastName("Shulz").withDspaceObjectOwner(researcher2.getFullName(), researcher2.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson2, "person", "identifier", "orcid", "en", "0000-0002-1826-4497");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        Item itemPublication2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Laura, Shulz").withTitle("The Impact of Interactive Epistemologies on Cryptography").withIssueDate("2013-02-17").build();
        Item itemProject = ItemBuilder.createItem((Context)this.context, (Collection)col3).withTitle("Title Project").build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson, "dc", "identifier", "scopus", null, "7004769520");
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson, (Item)itemPublication).build();
        OrcidQueue orcidQueue2 = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson2, (Item)itemPublication2).build();
        OrcidQueue orcidQueue3 = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson, (Item)itemProject).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenResearcher = this.getAuthToken(researcher.getEmail(), this.password);
        String tokenResearcher2 = this.getAuthToken(researcher2.getEmail(), this.password);
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidqueues/search/findByProfileItem", (Object[])new Object[0]).param("profileItemId", new String[]{itemPerson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.orcidqueues", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{OrcidQueueMatcher.matchOrcidQueue(orcidQueue), OrcidQueueMatcher.matchOrcidQueue(orcidQueue3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenResearcher2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidqueues/search/findByProfileItem", (Object[])new Object[0]).param("profileItemId", new String[]{itemPerson2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.orcidqueues", (Matcher)Matchers.contains(OrcidQueueMatcher.matchOrcidQueue(orcidQueue2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/eperson/orcidqueues/search/findByProfileItem")));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidqueues/search/findByProfileItem", (Object[])new Object[0]).param("profileItemId", new String[]{itemPerson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.orcidqueues", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{OrcidQueueMatcher.matchOrcidQueue(orcidQueue), OrcidQueueMatcher.matchOrcidQueue(orcidQueue3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByProfileItemForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        EPerson researcher2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Laura", "Shulz").withEmail("laura.shulz@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        Item itemPerson2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Laura").withPersonIdentifierLastName("Shulz").withDspaceObjectOwner(researcher2.getFullName(), researcher2.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson2, "person", "identifier", "orcid", "en", "0000-0002-1826-4497");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        Item itemPublication2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Laura, Shulz").withTitle("The Impact of Interactive Epistemologies on Cryptography").withIssueDate("2013-02-17").build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson, "dc", "identifier", "scopus", null, "7004769520");
        OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson, (Item)itemPublication).build();
        OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson2, (Item)itemPublication2).build();
        this.context.restoreAuthSystemState();
        String tokenResearcher2 = this.getAuthToken(researcher2.getEmail(), this.password);
        this.getClient(tokenResearcher2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidqueues/search/findByProfileItem", (Object[])new Object[0]).param("profileItemId", new String[]{itemPerson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByProfileItemUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson, "dc", "identifier", "scopus", null, "7004769520");
        OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson, (Item)itemPublication).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidqueues/search/findByProfileItem", (Object[])new Object[0]).param("profileItemId", new String[]{itemPerson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        EPerson researcher2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Laura", "Shulz").withEmail("Laura.Shulz@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        Item itemPerson2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Laura").withPersonIdentifierLastName("Shulz").withDspaceObjectOwner(researcher2.getFullName(), researcher2.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson1, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson2, "person", "identifier", "orcid", "en", "0000-0002-1825-0033");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        Item itemPublication2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Laura, Shulz").withTitle("Bulk and surface plasmons in artificially structured materials").withIssueDate("2015-05-21").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson1, (Item)itemPublication).withPutCode("12345").build();
        OrcidQueue orcidQueue2 = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson2, (Item)itemPublication2).build();
        this.context.restoreAuthSystemState();
        String tokenResearcher = this.getAuthToken(researcher.getEmail(), this.password);
        String tokenResearcher2 = this.getAuthToken(researcher2.getEmail(), this.password);
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(OrcidQueueMatcher.matchOrcidQueue(orcidQueue)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/orcidqueues/" + orcidQueue.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.profileItem.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + itemPerson1.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.entity.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + itemPublication.getID()))));
        this.getClient(tokenResearcher2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue2.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(OrcidQueueMatcher.matchOrcidQueue(orcidQueue2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/orcidqueues/" + orcidQueue2.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.profileItem.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + itemPerson2.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.entity.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + itemPublication2.getID()))));
    }

    @Test
    public void findOneWithDeleteRecordTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Item itemPerson = ItemBuilder.createItem((Context)this.context, (Collection)collection).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withOrcidIdentifier("0000-0002-1825-0097").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson, (String)"Description", (String)"Publication", (String)"12345").build();
        this.context.restoreAuthSystemState();
        String tokenResearcher = this.getAuthToken(researcher.getEmail(), this.password);
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(OrcidQueueMatcher.matchOrcidQueue(orcidQueue)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/orcidqueues/" + orcidQueue.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.profileItem.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + itemPerson.getID()))));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson1, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson1, (Item)itemPublication).build();
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson1, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson1, (Item)itemPublication).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidQueues/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson1, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson1, (Item)itemPublication).build();
        this.context.restoreAuthSystemState();
        String tokenResearcher = this.getAuthToken(researcher.getEmail(), this.password);
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/orcidqueues/" + orcidQueue.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson1, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson1, (Item)itemPublication).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenResearcher = this.getAuthToken(researcher.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/orcidqueues/" + orcidQueue.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(OrcidQueueMatcher.matchOrcidQueue(orcidQueue))));
    }

    @Test
    public void deleteOneUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        Item itemPerson1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withDspaceObjectOwner(researcher.getFullName(), researcher.getID().toString()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)itemPerson1, "person", "identifier", "orcid", "en", "0000-0002-1825-0097");
        Item itemPublication = ItemBuilder.createItem((Context)this.context, (Collection)col2).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)itemPerson1, (Item)itemPublication).build();
        this.context.restoreAuthSystemState();
        String tokenResearcher = this.getAuthToken(researcher.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/orcidqueues/" + orcidQueue.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidqueues/" + orcidQueue.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(OrcidQueueMatcher.matchOrcidQueue(orcidQueue))));
    }

    @Test
    public void deleteOneNotFoundTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/orcidqueues/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

