/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import org.dspace.app.rest.matcher.CommunityMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CommunitySubcommunityLinkRepositoryIT
extends AbstractControllerIntegrationTest {
    Community parentCommunity;
    Community subCommunity1;
    Community subCommunity2;
    Community subCommunity3;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        this.subCommunity1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub community 1").build();
        this.subCommunity2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub community 2").build();
        this.subCommunity3 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub community 3").build();
        this.context.commit();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void getSubCommunities_sortTitleASC() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/subcommunities"), (Object[])new Object[0]).param("sort", new String[]{"dc.title,ASC"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.contains((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(this.subCommunity1), CommunityMatcher.matchCommunity(this.subCommunity2), CommunityMatcher.matchCommunity(this.subCommunity3)})));
    }

    @Test
    public void getSubCommunities_sortTitleDESC() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/subcommunities"), (Object[])new Object[0]).param("sort", new String[]{"dc.title,DESC"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.contains((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(this.subCommunity3), CommunityMatcher.matchCommunity(this.subCommunity2), CommunityMatcher.matchCommunity(this.subCommunity1)})));
    }
}

