/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.assertj.core.api.Assertions;
import org.dspace.app.rest.security.DSpaceCsrfTokenRepository;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.DeferredCsrfToken;

@RunWith(value=MockitoJUnitRunner.class)
public class DSpaceCsrfTokenRepositoryTest {
    DSpaceCsrfTokenRepository repository;
    MockHttpServletResponse response;
    MockHttpServletRequest request;

    @Before
    public void setup() {
        this.repository = new DSpaceCsrfTokenRepository();
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.request.setContextPath("/context");
    }

    @Test
    public void generateToken() {
        CsrfToken generateToken = this.repository.generateToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)generateToken).isNotNull();
        Assertions.assertThat((String)generateToken.getHeaderName()).isEqualTo("X-XSRF-TOKEN");
        Assertions.assertThat((String)generateToken.getParameterName()).isEqualTo("_csrf");
        Assertions.assertThat((String)generateToken.getToken()).isNotEmpty();
    }

    @Test
    public void generateTokenCustom() {
        String headerName = "headerName";
        String parameterName = "paramName";
        this.repository.setHeaderName(headerName);
        this.repository.setParameterName(parameterName);
        CsrfToken generateToken = this.repository.generateToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)generateToken).isNotNull();
        Assertions.assertThat((String)generateToken.getHeaderName()).isEqualTo(headerName);
        Assertions.assertThat((String)generateToken.getParameterName()).isEqualTo(parameterName);
        Assertions.assertThat((String)generateToken.getToken()).isNotEmpty();
    }

    @Test
    public void saveToken() {
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isEqualTo(-1);
        Assertions.assertThat((String)tokenCookie.getName()).isEqualTo("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isEqualTo(this.request.isSecure());
        Assertions.assertThat((String)tokenCookie.getValue()).isEqualTo(token.getToken());
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isTrue();
    }

    @Test
    public void saveTokenShouldUseResponseAddCookie() {
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        MockHttpServletResponse spyResponse = (MockHttpServletResponse)Mockito.spy((Object)this.response);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)spyResponse);
        ((MockHttpServletResponse)Mockito.verify((Object)spyResponse)).addCookie((Cookie)ArgumentMatchers.any(Cookie.class));
    }

    @Test
    public void saveTokenSecure() {
        this.request.setSecure(true);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isTrue();
        Assertions.assertThat((String)tokenCookie.getAttribute("SameSite")).containsIgnoringCase((CharSequence)"None");
    }

    @Test
    public void saveTokenNotSecure() {
        this.request.setSecure(false);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isFalse();
        Assertions.assertThat((String)tokenCookie.getAttribute("SameSite")).containsIgnoringCase((CharSequence)"Lax");
    }

    @Test
    public void saveTokenSecureFlagTrue() {
        this.request.setSecure(false);
        this.repository.setSecure(Boolean.TRUE);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isTrue();
    }

    @Test
    public void saveTokenSecureFlagTrueUsingCustomizer() {
        this.request.setSecure(false);
        this.repository.setCookieCustomizer(customizer -> customizer.secure(Boolean.TRUE.booleanValue()));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isTrue();
    }

    @Test
    public void saveTokenSecureFlagFalse() {
        this.request.setSecure(true);
        this.repository.setSecure(Boolean.FALSE);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isFalse();
    }

    @Test
    public void saveTokenSecureFlagFalseUsingCustomizer() {
        this.request.setSecure(true);
        this.repository.setCookieCustomizer(customizer -> customizer.secure(Boolean.FALSE.booleanValue()));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isFalse();
    }

    @Test
    public void saveTokenNull() {
        this.request.setSecure(true);
        this.repository.saveToken(null, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isZero();
        Assertions.assertThat((String)tokenCookie.getName()).isEqualTo("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isEqualTo(this.request.isSecure());
        Assertions.assertThat((String)tokenCookie.getValue()).isEmpty();
    }

    @Test
    public void saveTokenHttpOnlyTrue() {
        this.repository.setCookieHttpOnly(true);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isTrue();
    }

    @Test
    public void saveTokenHttpOnlyTrueUsingCustomizer() {
        this.repository.setCookieCustomizer(customizer -> customizer.httpOnly(true));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isTrue();
    }

    @Test
    public void saveTokenHttpOnlyFalse() {
        this.repository.setCookieHttpOnly(false);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isFalse();
    }

    @Test
    public void saveTokenHttpOnlyFalseUsingCustomizer() {
        this.repository.setCookieCustomizer(customizer -> customizer.httpOnly(false));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isFalse();
    }

    @Test
    public void saveTokenWithHttpOnlyFalse() {
        this.repository = DSpaceCsrfTokenRepository.withHttpOnlyFalse();
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isFalse();
    }

    @Test
    public void saveTokenCustomPath() {
        String customPath = "/custompath";
        this.repository.setCookiePath(customPath);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.repository.getCookiePath());
    }

    @Test
    public void saveTokenEmptyCustomPath() {
        String customPath = "";
        this.repository.setCookiePath(customPath);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
    }

    @Test
    public void saveTokenNullCustomPath() {
        String customPath = null;
        this.repository.setCookiePath(customPath);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
    }

    @Test
    public void saveTokenWithCookieDomain() {
        String domainName = "example.com";
        this.repository.setCookieDomain(domainName);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getDomain()).isEqualTo(domainName);
    }

    @Test
    public void saveTokenWithCookieDomainUsingCustomizer() {
        String domainName = "example.com";
        this.repository.setCookieCustomizer(customizer -> customizer.domain(domainName));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getDomain()).isEqualTo(domainName);
    }

    @Test
    public void saveTokenWithCookieMaxAge() {
        int maxAge = 1200;
        this.repository.setCookieMaxAge(maxAge);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isEqualTo(maxAge);
    }

    @Test
    public void saveTokenWithCookieMaxAgeUsingCustomizer() {
        int maxAge = 1200;
        this.repository.setCookieCustomizer(customizer -> customizer.maxAge((long)maxAge));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isEqualTo(maxAge);
    }

    @Test
    public void saveTokenWithSameSiteNull() {
        String sameSitePolicy = null;
        this.repository.setCookieCustomizer(customizer -> customizer.sameSite(sameSitePolicy));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getAttribute("SameSite")).isNull();
    }

    @Test
    public void saveTokenWithSameSiteStrict() {
        String sameSitePolicy = "Strict";
        this.repository.setCookieCustomizer(customizer -> customizer.sameSite(sameSitePolicy));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getAttribute("SameSite")).isEqualTo(sameSitePolicy);
    }

    @Test
    public void saveTokenWithSameSiteLax() {
        String sameSitePolicy = "Lax";
        this.repository.setCookieCustomizer(customizer -> customizer.sameSite(sameSitePolicy));
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getAttribute("SameSite")).isEqualTo(sameSitePolicy);
    }

    @Test
    public void saveTokenWithExistingSetCookieThenDoesNotOverwrite() {
        this.response.setHeader("Set-Cookie", "MyCookie=test");
        this.repository = new DSpaceCsrfTokenRepository();
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Assertions.assertThat((Object)this.response.getCookie("MyCookie")).isNotNull();
        Assertions.assertThat((Object)this.response.getCookie("DSPACE-XSRF-COOKIE")).isNotNull();
    }

    @Test
    public void loadTokenNoCookiesNull() {
        Assertions.assertThat((Object)this.repository.loadToken((HttpServletRequest)this.request)).isNull();
    }

    @Test
    public void loadTokenCookieIncorrectNameNull() {
        this.request.setCookies(new Cookie[]{new Cookie("other", "name")});
        Assertions.assertThat((Object)this.repository.loadToken((HttpServletRequest)this.request)).isNull();
    }

    @Test
    public void loadTokenCookieValueEmptyString() {
        this.request.setCookies(new Cookie[]{new Cookie("DSPACE-XSRF-COOKIE", "")});
        Assertions.assertThat((Object)this.repository.loadToken((HttpServletRequest)this.request)).isNull();
    }

    @Test
    public void loadToken() {
        CsrfToken generateToken = this.repository.generateToken((HttpServletRequest)this.request);
        this.request.setCookies(new Cookie[]{new Cookie("DSPACE-XSRF-COOKIE", generateToken.getToken())});
        CsrfToken loadToken = this.repository.loadToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)loadToken).isNotNull();
        Assertions.assertThat((String)loadToken.getHeaderName()).isEqualTo(generateToken.getHeaderName());
        Assertions.assertThat((String)loadToken.getParameterName()).isEqualTo(generateToken.getParameterName());
        Assertions.assertThat((String)loadToken.getToken()).isNotEmpty();
    }

    @Test
    public void loadTokenCustom() {
        String cookieName = "cookieName";
        String value = "value";
        String headerName = "headerName";
        String parameterName = "paramName";
        this.repository.setHeaderName(headerName);
        this.repository.setParameterName(parameterName);
        this.repository.setCookieName(cookieName);
        this.request.setCookies(new Cookie[]{new Cookie(cookieName, value)});
        CsrfToken loadToken = this.repository.loadToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)loadToken).isNotNull();
        Assertions.assertThat((String)loadToken.getHeaderName()).isEqualTo(headerName);
        Assertions.assertThat((String)loadToken.getParameterName()).isEqualTo(parameterName);
        Assertions.assertThat((String)loadToken.getToken()).isEqualTo(value);
    }

    @Test
    public void loadDeferredTokenWhenDoesNotExistThenGeneratedAndSaved() {
        DeferredCsrfToken deferredCsrfToken = this.repository.loadDeferredToken((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        CsrfToken csrfToken = deferredCsrfToken.get();
        Assertions.assertThat((Object)csrfToken).isNotNull();
        Assertions.assertThat((boolean)deferredCsrfToken.isGenerated()).isTrue();
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((Object)tokenCookie).isNotNull();
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isEqualTo(-1);
        Assertions.assertThat((String)tokenCookie.getName()).isEqualTo("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isEqualTo(this.request.isSecure());
        Assertions.assertThat((String)tokenCookie.getValue()).isEqualTo(csrfToken.getToken());
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isEqualTo(true);
    }

    @Test
    public void loadDeferredTokenWhenExistsAndNullSavedThenGeneratedAndSaved() {
        CsrfToken generatedToken = this.repository.generateToken((HttpServletRequest)this.request);
        this.request.setCookies(new Cookie[]{new Cookie("DSPACE-XSRF-COOKIE", generatedToken.getToken())});
        this.repository.saveToken(null, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        DeferredCsrfToken deferredCsrfToken = this.repository.loadDeferredToken((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        CsrfToken csrfToken = deferredCsrfToken.get();
        Assertions.assertThat((Object)csrfToken).isNotNull();
        Assertions.assertThat((Object)generatedToken).isNotEqualTo((Object)csrfToken);
        Assertions.assertThat((boolean)deferredCsrfToken.isGenerated()).isTrue();
    }

    @Test
    public void cookieCustomizer() {
        String domainName = "example.com";
        String customPath = "/custompath";
        String sameSitePolicy = "Strict";
        this.repository.setCookieCustomizer(customizer -> {
            customizer.domain(domainName);
            customizer.secure(false);
            customizer.path(customPath);
            customizer.sameSite(sameSitePolicy);
        });
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((Object)tokenCookie).isNotNull();
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isEqualTo(-1);
        Assertions.assertThat((String)tokenCookie.getDomain()).isEqualTo(domainName);
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(customPath);
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((String)tokenCookie.getAttribute("SameSite")).isEqualTo(sameSitePolicy);
    }

    @Test
    public void withHttpOnlyFalseWhenCookieCustomizerThenStillDefaultsToFalse() {
        DSpaceCsrfTokenRepository repository = DSpaceCsrfTokenRepository.withHttpOnlyFalse();
        repository.setCookieCustomizer(customizer -> customizer.maxAge(1000L));
        CsrfToken token = repository.generateToken((HttpServletRequest)this.request);
        repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((Object)tokenCookie).isNotNull();
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isEqualTo(1000);
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void setCookieNameNullIllegalArgumentException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.setCookieName(null));
    }

    @Test
    public void setParameterNameNullIllegalArgumentException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.setParameterName(null));
    }

    @Test
    public void setHeaderNameNullIllegalArgumentException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.setHeaderName(null));
    }

    @Test
    public void setCookieMaxAgeZeroIllegalArgumentException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.setCookieMaxAge(0));
    }
}

