/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.dspace.AbstractDSpaceTest;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.security.SamlLoginFilter;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;

public class SamlLoginFilterTest
extends AbstractDSpaceTest {
    private static ConfigurationService configurationService;
    private AuthenticationManager authManager;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private RestAuthenticationService restAuthService;
    private FilterChain filterChain;
    private SamlLoginFilter filter;

    @BeforeClass
    public static void beforeAll() {
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    @Before
    public void beforeEach() throws Exception {
        this.resetConfigurationService();
        this.authManager = this.createAuthenticationManager();
        this.restAuthService = this.createRestAuthenticationService();
        this.filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        this.filter = new SamlLoginFilter("/api/authn/saml", HttpMethod.GET.name(), this.authManager, this.restAuthService);
        this.request = this.createRequest("/api/authn/saml");
        this.response = this.createResponse();
    }

    @Test
    public void testRedirectAfterSuccess() throws Exception {
        configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)"org.dspace.authenticate.SamlAuthentication");
        configurationService.setProperty("dspace.ui.url", (Object)"http://dspace.example.org");
        configurationService.setProperty("dspace.server.url", (Object)"http://dspace.example.org/server");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendRedirect("http://dspace.example.org");
    }

    @Test
    public void testRedirectToRemoteHostNotAllowed() throws Exception {
        configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)"org.dspace.authenticate.SamlAuthentication");
        configurationService.setProperty("dspace.ui.url", (Object)"http://different.host.bad");
        configurationService.setProperty("dspace.server.url", (Object)"http://dspace.example.org/server");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendError(ArgumentMatchers.eq((int)400), ArgumentMatchers.anyString());
    }

    @Test
    public void testRedirectToRemoteHostCorsAllowed() throws Exception {
        configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)"org.dspace.authenticate.SamlAuthentication");
        configurationService.setProperty("rest.cors.allowed-origins", (Object)"http://different.host.ok");
        configurationService.setProperty("dspace.ui.url", (Object)"http://different.host.ok");
        configurationService.setProperty("dspace.server.url", (Object)"http://dspace.example.org/server");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendRedirect("http://different.host.ok");
    }

    @Test
    public void testAuthCookieSaved() throws Exception {
        configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)"org.dspace.authenticate.SamlAuthentication");
        configurationService.setProperty("dspace.ui.url", (Object)"http://dspace.example.org");
        configurationService.setProperty("dspace.server.url", (Object)"http://dspace.example.org/server");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((RestAuthenticationService)Mockito.verify((Object)this.restAuthService)).addAuthenticationDataForUser((HttpServletRequest)ArgumentMatchers.eq((Object)this.request), (HttpServletResponse)ArgumentMatchers.eq((Object)this.response), (DSpaceAuthentication)ArgumentMatchers.any(DSpaceAuthentication.class), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testSamlAuthenticationNotEnabled() throws Exception {
        Assert.assertThrows(ProviderNotFoundException.class, () -> this.filter.attemptAuthentication(this.request, this.response));
    }

    private void resetConfigurationService() {
        ((DSpaceConfigurationService)configurationService).clear();
        configurationService.reloadConfig();
    }

    private AuthenticationManager createAuthenticationManager() {
        AuthenticationManager mockAuthManager = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)mockAuthManager.authenticate((Authentication)ArgumentMatchers.any(Authentication.class))).thenReturn((Object)((Authentication)Mockito.mock(DSpaceAuthentication.class)));
        return mockAuthManager;
    }

    private RestAuthenticationService createRestAuthenticationService() throws Exception {
        RestAuthenticationService mockRestAuthService = (RestAuthenticationService)Mockito.mock(RestAuthenticationService.class);
        ((RestAuthenticationService)Mockito.doNothing().when((Object)mockRestAuthService)).addAuthenticationDataForUser((HttpServletRequest)ArgumentMatchers.isA(HttpServletRequest.class), (HttpServletResponse)ArgumentMatchers.isA(HttpServletResponse.class), (DSpaceAuthentication)ArgumentMatchers.isA(DSpaceAuthentication.class), ((Boolean)ArgumentMatchers.isA(Boolean.class)).booleanValue());
        return mockRestAuthService;
    }

    private HttpServletRequest createRequest(String path) {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), path);
        mockRequest.setPathInfo(path);
        return mockRequest;
    }

    private HttpServletResponse createResponse() throws Exception {
        HttpServletResponse mockResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ((HttpServletResponse)Mockito.doNothing().when((Object)mockResponse)).sendRedirect((String)ArgumentMatchers.isA(String.class));
        ((HttpServletResponse)Mockito.doNothing().when((Object)mockResponse)).sendError(((Integer)ArgumentMatchers.isA(Integer.class)).intValue(), (String)ArgumentMatchers.isA(String.class));
        return mockResponse;
    }
}

