/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.dspace.app.rest.security.jwt.EPersonClaimProvider;
import org.dspace.app.rest.security.jwt.JWTClaimProvider;
import org.dspace.app.rest.security.jwt.LoginJWTTokenHandler;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

@RunWith(value=MockitoJUnitRunner.class)
public class JWTTokenHandlerTest {
    @InjectMocks
    @Spy
    private LoginJWTTokenHandler loginJWTTokenHandler;
    @Mock
    protected ConfigurationService configurationService;
    @Mock
    protected Context context;
    @Mock
    protected EPerson ePerson;
    @Mock
    protected HttpServletRequest httpServletRequest;
    @Mock
    protected EPersonService ePersonService;
    @Mock
    protected EPersonClaimProvider ePersonClaimProvider;
    @Mock
    protected ClientInfoService clientInfoService;
    @Spy
    protected List<JWTClaimProvider> jwtClaimProviders = new ArrayList<JWTClaimProvider>();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.ePerson.getSessionSalt()).thenReturn((Object)"01234567890123456789012345678901");
        Mockito.when((Object)this.ePerson.getLastActive()).thenReturn((Object)Instant.now());
        Mockito.when((Object)this.context.getCurrentUser()).thenReturn((Object)this.ePerson);
        Mockito.when((Object)this.clientInfoService.getClientIp((HttpServletRequest)ArgumentMatchers.any())).thenReturn((Object)"123.123.123.123");
        Mockito.when((Object)this.ePersonClaimProvider.getKey()).thenReturn((Object)"eid");
        Mockito.when((Object)this.ePersonClaimProvider.getValue((Context)ArgumentMatchers.any(), (HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)"epersonID");
        this.jwtClaimProviders.add((JWTClaimProvider)this.ePersonClaimProvider);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testJWTNoEncryption() throws Exception {
        Instant previous = Instant.now().minus(10000000000L, ChronoUnit.MILLIS);
        String token = this.loginJWTTokenHandler.createTokenForEPerson(this.context, (HttpServletRequest)new MockHttpServletRequest(), previous);
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        String personId = (String)signedJWT.getJWTClaimsSet().getClaim("eid");
        Assert.assertEquals((Object)"epersonID", (Object)personId);
    }

    @Test(expected=ParseException.class)
    public void testJWTEncrypted() throws Exception {
        Mockito.when((Object)this.loginJWTTokenHandler.isEncryptionEnabled()).thenReturn((Object)true);
        Instant previous = Instant.now().minus(10000000000L, ChronoUnit.MILLIS);
        StringKeyGenerator keyGenerator = KeyGenerators.string();
        Mockito.when((Object)this.configurationService.getProperty("jwt.login.encryption.secret")).thenReturn((Object)keyGenerator.generateKey());
        String token = this.loginJWTTokenHandler.createTokenForEPerson(this.context, (HttpServletRequest)new MockHttpServletRequest(), previous);
        SignedJWT signedJWT = SignedJWT.parse((String)token);
    }

    @Test
    public void testExpiredToken() throws Exception {
        Mockito.when((Object)this.configurationService.getLongProperty("jwt.login.token.expiration", 1800000L)).thenReturn((Object)-99999999L);
        Mockito.when((Object)this.ePersonClaimProvider.getEPerson((Context)ArgumentMatchers.any(Context.class), (JWTClaimsSet)ArgumentMatchers.any(JWTClaimsSet.class))).thenReturn((Object)this.ePerson);
        Instant previous = Instant.now().minus(10000000000L, ChronoUnit.MILLIS);
        String token = this.loginJWTTokenHandler.createTokenForEPerson(this.context, (HttpServletRequest)new MockHttpServletRequest(), previous);
        EPerson parsed = this.loginJWTTokenHandler.parseEPersonFromToken(token, this.httpServletRequest, this.context);
        Assert.assertEquals(null, (Object)parsed);
    }

    @Test
    public void testTokenTampering() throws Exception {
        Mockito.when((Object)this.loginJWTTokenHandler.getExpirationPeriod()).thenReturn((Object)-99999999L);
        Mockito.when((Object)this.ePersonClaimProvider.getEPerson((Context)ArgumentMatchers.any(Context.class), (JWTClaimsSet)ArgumentMatchers.any(JWTClaimsSet.class))).thenReturn((Object)this.ePerson);
        Instant previous = Instant.now().minus(10000000000L, ChronoUnit.MILLIS);
        String token = this.loginJWTTokenHandler.createTokenForEPerson(this.context, (HttpServletRequest)new MockHttpServletRequest(), previous);
        JWTClaimsSet jwtClaimsSet = new JWTClaimsSet.Builder().claim("eid", (Object)"epersonID").expirationTime(Date.from(Instant.now().plus(99999999L, ChronoUnit.MILLIS))).build();
        String tamperedPayload = new String(Base64.getUrlEncoder().encode(jwtClaimsSet.toString().getBytes()));
        String[] splitToken = token.split("\\.");
        String tamperedToken = splitToken[0] + "." + tamperedPayload + "." + splitToken[2];
        EPerson parsed = this.loginJWTTokenHandler.parseEPersonFromToken(tamperedToken, this.httpServletRequest, this.context);
        Assert.assertEquals(null, (Object)parsed);
    }

    @Test
    public void testInvalidatedToken() throws Exception {
        Instant previous = Instant.now().minus(10000000000L, ChronoUnit.MILLIS);
        String token = this.loginJWTTokenHandler.createTokenForEPerson(this.context, (HttpServletRequest)new MockHttpServletRequest(), previous);
        this.loginJWTTokenHandler.invalidateToken(token, (HttpServletRequest)new MockHttpServletRequest(), this.context);
        EPerson parsed = this.loginJWTTokenHandler.parseEPersonFromToken(token, this.httpServletRequest, this.context);
        Assert.assertEquals(null, (Object)parsed);
    }
}

