/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Filter;
import jakarta.servlet.http.Cookie;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.TestApplication;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.utils.DSpaceConfigurationInitializer;
import org.dspace.app.rest.utils.DSpaceKernelInitializer;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.servlet.support.ErrorPageFilter;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.hateoas.MediaTypes;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={TestApplication.class})
@ContextConfiguration(initializers={DSpaceKernelInitializer.class, DSpaceConfigurationInitializer.class})
@WebAppConfiguration
@TestPropertySource(locations={"classpath:application-test.properties"})
public class AbstractControllerIntegrationTest
extends AbstractIntegrationTestWithDatabase {
    private static final Logger log = LogManager.getLogger();
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String AUTHORIZATION_COOKIE = "Authorization-cookie";
    protected static final String AUTHORIZATION_TYPE = "Bearer ";
    public static final String REST_SERVER_URL = "http://localhost/api/";
    public static final String BASE_REST_SERVER_URL = "http://localhost";
    protected MediaType contentType = new MediaType(MediaTypes.HAL_JSON.getType(), MediaTypes.HAL_JSON.getSubtype(), StandardCharsets.UTF_8);
    protected MediaType textUriContentType = RestMediaTypes.TEXT_URI_LIST;
    protected HttpMessageConverter mappingJackson2HttpMessageConverter;
    @Autowired
    private WebApplicationContext webApplicationContext;
    @Autowired
    private List<Filter> requestFilters;
    @Autowired
    private ObjectMapper mapper;

    @Autowired
    void setConverters(HttpMessageConverter<?>[] converters) {
        this.mappingJackson2HttpMessageConverter = Arrays.asList(converters).stream().filter(hmc -> hmc instanceof MappingJackson2HttpMessageConverter).findAny().get();
        Assert.assertNotNull((String)"the JSON message converter must not be null", (Object)this.mappingJackson2HttpMessageConverter);
    }

    public MockMvc getClient() throws SQLException {
        return this.getClient(null);
    }

    public MockMvc getClient(String authToken) throws SQLException {
        if (this.context != null && this.context.isValid()) {
            this.context.commit();
        }
        DefaultMockMvcBuilder mockMvcBuilder = this.setupDefaultMockMvcBuilder(true);
        MockHttpServletRequestBuilder defaultRequest = MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)authToken)) {
            defaultRequest.header(AUTHORIZATION_HEADER, new Object[]{AUTHORIZATION_TYPE + authToken});
        }
        defaultRequest.with(this.validCsrfToken());
        return ((DefaultMockMvcBuilder)mockMvcBuilder.defaultRequest((RequestBuilder)defaultRequest)).build();
    }

    public MockHttpServletResponse getAuthResponse(String user, String password) throws Exception {
        return this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{user}).param("password", new String[]{password})).andReturn().getResponse();
    }

    public MockHttpServletResponse getAuthResponseWithXForwardedForHeader(String user, String password, String xForwardedFor) throws Exception {
        return this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{user}).param("password", new String[]{password}).header("X-Forwarded-For", new Object[]{xForwardedFor})).andReturn().getResponse();
    }

    public String getAuthToken(String user, String password) throws Exception {
        return StringUtils.substringAfter((String)this.getAuthResponse(user, password).getHeader(AUTHORIZATION_HEADER), (String)AUTHORIZATION_TYPE);
    }

    public String getAuthTokenWithXForwardedForHeader(String user, String password, String xForwardedFor) throws Exception {
        return StringUtils.substringAfter((String)this.getAuthResponseWithXForwardedForHeader(user, password, xForwardedFor).getHeader(AUTHORIZATION_HEADER), (String)AUTHORIZATION_TYPE);
    }

    public String getPatchContent(List<Operation> ops) {
        try {
            return this.mapper.writeValueAsString(ops);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RequestPostProcessor ip(String ipAddress) {
        return request -> {
            request.setRemoteAddr(ipAddress);
            return request;
        };
    }

    public RequestPostProcessor validCsrfToken() {
        return request -> {
            Cookie csrfCookie = this.getCsrfTokenCookie();
            if (csrfCookie != null) {
                Object[] cookies = request.getCookies();
                request.setCookies((Cookie[])ArrayUtils.add((Object[])cookies, (Object)csrfCookie));
                request.addHeader("X-XSRF-TOKEN", (Object)csrfCookie.getValue());
                return request;
            }
            log.warn("Could not obtain CSRFToken to add it to the current mock request");
            return request;
        };
    }

    public RequestPostProcessor validCsrfTokenViaParam() {
        return request -> {
            Cookie csrfCookie = this.getCsrfTokenCookie();
            if (csrfCookie != null) {
                Object[] cookies = request.getCookies();
                cookies = (Cookie[])Arrays.stream(cookies).filter(c -> !c.getName().equalsIgnoreCase("DSPACE-XSRF-COOKIE")).toArray(Cookie[]::new);
                request.removeHeader("X-XSRF-TOKEN");
                request.setCookies((Cookie[])ArrayUtils.add((Object[])cookies, (Object)csrfCookie));
                request.addParameter("_csrf", csrfCookie.getValue());
                return request;
            }
            log.warn("Could not obtain CSRFToken to add it to the current mock request");
            return request;
        };
    }

    public RequestPostProcessor invalidCsrfToken() {
        return request -> {
            Object[] cookies = request.getCookies();
            cookies = (Cookie[])Arrays.stream(cookies).filter(c -> !c.getName().equalsIgnoreCase("DSPACE-XSRF-COOKIE")).toArray(Cookie[]::new);
            request.removeHeader("X-XSRF-TOKEN");
            request.setCookies((Cookie[])ArrayUtils.add((Object[])cookies, (Object)new Cookie("DSPACE-XSRF-COOKIE", "fake-csrf-token")));
            request.addHeader("X-XSRF-TOKEN", (Object)"not-a-valid-csrf-token");
            return request;
        };
    }

    private DefaultMockMvcBuilder setupDefaultMockMvcBuilder(boolean enableLogging) {
        DefaultMockMvcBuilder defaultMockMvcBuilder = (DefaultMockMvcBuilder)((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).addFilters(new Filter[]{new ErrorPageFilter()})).addFilters(this.requestFilters.toArray(new Filter[this.requestFilters.size()]))).apply(SecurityMockMvcConfigurers.springSecurity());
        if (enableLogging) {
            return (DefaultMockMvcBuilder)defaultMockMvcBuilder.alwaysDo(MockMvcResultHandlers.print());
        }
        return defaultMockMvcBuilder;
    }

    public Cookie getCsrfTokenCookie() {
        try {
            MockMvc mockMvc = this.setupDefaultMockMvcBuilder(false).build();
            MvcResult mvcResult = mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/security/csrf", (Object[])new Object[0])).andReturn();
            return mvcResult.getResponse().getCookie("DSPACE-XSRF-COOKIE");
        }
        catch (Exception e) {
            log.error("Could not obtain the CSRF token cookie for Integration Tests", (Throwable)e);
            return null;
        }
    }
}

