/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.test;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractEntityIntegrationTest
extends AbstractControllerIntegrationTest {
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    protected RelationshipTypeService relationshipTypeService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (this.entityTypeService.findAll(this.context).size() > 1) {
            return;
        }
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Person").build();
        EntityType project = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        EntityType orgUnit = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        EntityType journal = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Journal").build();
        EntityType journalVolume = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"JournalVolume").build();
        EntityType journalIssue = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"JournalIssue").build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)person, (String)"isAuthorOfPublication", (String)"isPublicationOfAuthor", (Integer)0, null, (Integer)0, null).withCopyToLeft(false).withCopyToRight(true).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)project, (String)"isProjectOfPublication", (String)"isPublicationOfProject", (Integer)0, null, (Integer)0, null).withCopyToRight(true).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)orgUnit, (String)"isOrgUnitOfPublication", (String)"isPublicationOfOrgUnit", (Integer)0, null, (Integer)0, null).withCopyToLeft(false).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)person, (EntityType)project, (String)"isProjectOfPerson", (String)"isPersonOfProject", (Integer)0, null, (Integer)0, null).withCopyToLeft(true).withCopyToRight(true).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)person, (EntityType)orgUnit, (String)"isOrgUnitOfPerson", (String)"isPersonOfOrgUnit", (Integer)0, null, (Integer)0, null).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)project, (EntityType)orgUnit, (String)"isOrgUnitOfProject", (String)"isProjectOfOrgUnit", (Integer)0, null, (Integer)0, null).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journal, (EntityType)journalVolume, (String)"isVolumeOfJournal", (String)"isJournalOfVolume", (Integer)0, null, (Integer)1, null).withCopyToLeft(true).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journalVolume, (EntityType)journalIssue, (String)"isIssueOfJournalVolume", (String)"isJournalVolumeOfIssue", (Integer)0, null, (Integer)1, (Integer)1).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journalIssue, (EntityType)journalVolume, (String)"isJournalVolumeOfIssue", (String)"isIssueOfJournalVolume", null, null, null, null).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)orgUnit, (String)"isAuthorOfPublication", (String)"isPublicationOfAuthor", (Integer)0, null, (Integer)0, null).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journalIssue, (EntityType)publication, (String)"isPublicationOfJournalIssue", (String)"isJournalIssueOfPublication", (Integer)0, null, (Integer)0, (Integer)1).build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)orgUnit, (EntityType)orgUnit, (String)"isParentOrgUnitOf", (String)"isChildOrgUnitOf", null, (Integer)1, null, null).build();
        this.context.restoreAuthSystemState();
    }
}

