/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class MetadataPatchSuite {
    private final ObjectMapper mapper;
    private final JsonNode suite;

    public MetadataPatchSuite(ObjectMapper mapper) throws Exception {
        this.mapper = mapper;
        this.suite = mapper.readTree(this.getClass().getResourceAsStream("metadata-patch-suite.json"));
    }

    public void runWith(MockMvc client, String url, int expectedStatus) {
        for (JsonNode testNode : this.suite.get("tests")) {
            String requestBody = testNode.get("patch").toString();
            String expectedMetadata = testNode.get("expect").toString();
            try {
                System.out.println("Running patch test: " + testNode.get("name") + "\nRequest: " + requestBody);
                this.checkResponse("PATCH", client, MockMvcRequestBuilders.patch((String)url, (Object[])new Object[0]).content(requestBody), expectedMetadata, expectedStatus);
                if (expectedStatus < 200 || expectedStatus >= 300) continue;
                this.checkResponse("GET", client, MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]), expectedMetadata, expectedStatus);
            }
            catch (Throwable t) {
                Assert.fail((String)("Metadata patch test '" + testNode.get("name") + "' failed.\nRequest body: " + requestBody + "\nError: " + (t instanceof AssertionError ? "" : t.getClass().getName()) + t.getMessage()));
            }
        }
    }

    private void checkResponse(String verb, MockMvc client, MockHttpServletRequestBuilder requestBuilder, String expectedMetadata, int expectedStatus) throws Exception {
        String responseBody;
        JsonNode responseJson;
        String responseMetadata;
        ResultActions resultActions = client.perform((RequestBuilder)requestBuilder.contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().is(expectedStatus));
        if (expectedStatus >= 200 && expectedStatus < 300 && !(responseMetadata = (responseJson = this.mapper.readTree(responseBody = resultActions.andReturn().getResponse().getContentAsString())).get("metadata").toString()).equals(expectedMetadata)) {
            Assert.fail((String)("Expected metadata in " + verb + " response: " + expectedMetadata + "\nGot metadata in " + verb + " response: " + responseMetadata));
        }
    }
}

