/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.random.RandomGenerator;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.services.ConfigurationService;
import org.json.JSONObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/captcha"})
@RestController
public class AltchaCaptchaRestController
implements InitializingBean {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;
    private static Logger log = LogManager.getLogger();
    private static final long DEFAULT_EXPIRE_TIME = 3600000L;

    @GetMapping(value={"/challenge"})
    @PreAuthorize(value="permitAll()")
    public ResponseEntity getAltchaChallenge(HttpServletRequest request, HttpServletResponse response) {
        if (!this.configurationService.getProperty("captcha.provider", "google").equals("altcha")) {
            log.error("altcha is not enabled");
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.BAD_REQUEST);
        }
        String algorithm = this.configurationService.getProperty("altcha.algorithm", "SHA-256");
        String hmacKey = this.configurationService.getProperty("altcha.hmac.key");
        if (hmacKey == null) {
            log.error("hmac key not found, see: altcha.hmac.key in altcha.cfg");
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.BAD_REQUEST);
        }
        RandomGenerator generator = RandomGenerator.getDefault();
        String randomSalt = AltchaCaptchaRestController.bytesToHex(AltchaCaptchaRestController.generateSalt());
        int randomNumber = generator.nextInt(100000);
        String randomNumberString = String.valueOf(randomNumber);
        try {
            String challenge = AltchaCaptchaRestController.calculateHash(randomSalt + randomNumberString, algorithm);
            if (StringUtils.isBlank((CharSequence)challenge)) {
                log.error("Error generating altcha challenge");
                return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            String hmac = new HmacUtils("HmacSHA256", hmacKey).hmacHex(challenge);
            if (StringUtils.isBlank((CharSequence)hmac)) {
                log.error("Error generating HMAC signature");
                return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("algorithm", (Object)algorithm);
            jsonObject.put("challenge", (Object)challenge);
            jsonObject.put("salt", (Object)randomSalt);
            jsonObject.put("signature", (Object)hmac);
            String body = jsonObject.toString();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.put("Cache-Control", Collections.singletonList("private,no-cache"));
            httpHeaders.put("Expires", Collections.singletonList(FastHttpDateFormat.formatDate((long)(System.currentTimeMillis() + 3600000L))));
            httpHeaders.put("Content-Type", Collections.singletonList("application/json"));
            httpHeaders.put("Content-Length", Collections.singletonList(String.valueOf(body.getBytes(StandardCharsets.UTF_8).length)));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).body((Object)body);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("No such algorithm: {}, {}", (Object)algorithm, (Object)e.getMessage());
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.BAD_REQUEST);
        }
    }

    private static byte[] generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[5];
        random.nextBytes(salt);
        return salt;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes) {
            stringBuilder.append(String.format("%02x", b));
        }
        return stringBuilder.toString();
    }

    public static String calculateHash(String input, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance(algorithm);
        byte[] hashBytes = sha256.digest(input.getBytes());
        return AltchaCaptchaRestController.bytesToHex(hashBytes);
    }

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register(this, Arrays.asList(Link.of((String)"/api/captcha", (String)"captcha")));
    }
}

