/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.Filter;
import java.io.IOException;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import org.dspace.app.ldn.LDNQueueExtractor;
import org.dspace.app.ldn.LDNQueueTimeoutChecker;
import org.dspace.app.rest.filter.DSpaceRequestContextFilter;
import org.dspace.app.rest.model.hateoas.DSpaceLinkRelationProvider;
import org.dspace.app.rest.parameter.resolver.SearchFilterResolver;
import org.dspace.app.rest.utils.ApplicationConfig;
import org.dspace.app.rest.utils.DSpaceAPIRequestLoggingFilter;
import org.dspace.app.sitemap.GenerateSitemaps;
import org.dspace.app.solrdatabaseresync.SolrDatabaseResyncCli;
import org.dspace.app.util.DSpaceContextListener;
import org.dspace.google.GoogleAsyncEventListener;
import org.dspace.utils.servlet.DSpaceWebappServletFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableScheduling
@EnableCaching
@Configuration
public class WebApplication {
    @Autowired
    private ApplicationConfig configuration;
    @Autowired
    private GoogleAsyncEventListener googleAsyncEventListener;

    @Scheduled(cron="${sitemap.cron:-}")
    public void generateSitemap() throws IOException, SQLException {
        GenerateSitemaps.generateSitemapsScheduled();
    }

    @Scheduled(cron="${ldn.queue.extractor.cron:-}")
    public void ldnExtractFromQueue() throws IOException, SQLException {
        if (!this.configuration.getLdnEnabled()) {
            return;
        }
        LDNQueueExtractor.extractMessageFromQueue();
    }

    @Scheduled(cron="${ldn.queue.timeout.checker.cron:-}")
    public void ldnQueueTimeoutCheck() throws IOException, SQLException {
        if (!this.configuration.getLdnEnabled()) {
            return;
        }
        LDNQueueTimeoutChecker.checkQueueMessageTimeout();
    }

    @Scheduled(cron="${solr-database-resync.cron:-}")
    public void solrDatabaseResync() throws Exception {
        SolrDatabaseResyncCli.runScheduled();
    }

    @Scheduled(cron="${google.analytics.cron:-}")
    public void sendGoogleAnalyticsEvents() {
        this.googleAsyncEventListener.sendCollectedEvents();
    }

    @Bean
    @Order(value=2)
    protected DSpaceContextListener dspaceContextListener() {
        return new DSpaceContextListener();
    }

    @Bean
    @Order(value=1)
    protected Filter dspaceWebappServletFilter() {
        return new DSpaceWebappServletFilter();
    }

    @Bean
    @Order(value=2)
    protected Filter dspaceRequestContextFilter() {
        return new DSpaceRequestContextFilter();
    }

    @Bean
    @Order(value=3)
    protected Filter dspaceApiLoggingRequest() {
        return new DSpaceAPIRequestLoggingFilter();
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    protected LinkRelationProvider dspaceLinkRelationProvider() {
        return new DSpaceLinkRelationProvider();
    }

    @Bean
    public WebMvcConfigurer webMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(@NonNull CorsRegistry registry) {
                String[] corsAllowedOrigins = WebApplication.this.configuration.getCorsAllowedOrigins(WebApplication.this.configuration.getCorsAllowedOriginsConfig());
                String[] iiifAllowedOrigins = WebApplication.this.configuration.getCorsAllowedOrigins(WebApplication.this.configuration.getIiifAllowedOriginsConfig());
                String[] signpostingAllowedOrigins = WebApplication.this.configuration.getCorsAllowedOrigins(WebApplication.this.configuration.getSignpostingAllowedOriginsConfig());
                boolean corsAllowCredentials = WebApplication.this.configuration.getCorsAllowCredentials();
                boolean iiifAllowCredentials = WebApplication.this.configuration.getIiifAllowCredentials();
                boolean signpostingAllowCredentials = WebApplication.this.configuration.getSignpostingAllowCredentials();
                if (corsAllowedOrigins != null) {
                    registry.addMapping("/api/**").allowedMethods(new String[]{"*"}).allowCredentials(corsAllowCredentials).allowedOrigins(corsAllowedOrigins).allowedHeaders(new String[]{"Accept", "Authorization", "Content-Type", "Origin", "X-On-Behalf-Of", "X-Requested-With", "X-XSRF-TOKEN", "X-CORRELATION-ID", "X-REFERRER", "x-captcha-payload"}).exposedHeaders(new String[]{"Authorization", "DSPACE-XSRF-TOKEN", "Location", "WWW-Authenticate"});
                }
                if (iiifAllowedOrigins != null) {
                    registry.addMapping("/iiif/**").allowedMethods(new String[]{"*"}).allowCredentials(iiifAllowCredentials).allowedOrigins(iiifAllowedOrigins).allowedHeaders(new String[]{"Accept", "Authorization", "Content-Type", "Origin", "X-On-Behalf-Of", "X-Requested-With", "X-XSRF-TOKEN", "X-CORRELATION-ID", "X-REFERRER", "x-captcha-payload"}).exposedHeaders(new String[]{"Authorization", "DSPACE-XSRF-TOKEN", "Location", "WWW-Authenticate"});
                }
                if (signpostingAllowedOrigins != null) {
                    registry.addMapping("/signposting/**").allowedMethods(new String[]{"*"}).allowCredentials(signpostingAllowCredentials).allowedOrigins(signpostingAllowedOrigins).allowedHeaders(new String[]{"Accept", "Authorization", "Content-Type", "Origin", "X-On-Behalf-Of", "X-Requested-With", "X-XSRF-TOKEN", "X-CORRELATION-ID", "X-REFERRER", "x-captcha-payload", "access-control-allow-headers"}).exposedHeaders(new String[]{"Authorization", "DSPACE-XSRF-TOKEN", "Location", "WWW-Authenticate"});
                }
            }

            public void addViewControllers(ViewControllerRegistry registry) {
                registry.addViewController("/").setViewName("forward:/index.html");
            }

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{"/browser/**"}).addResourceLocations(new String[]{"/webjars/hal-browser/ad9b865/"});
                registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"/webjars/", "classpath:/META-INF/resources/webjars/"});
            }

            public void addArgumentResolvers(@NonNull List<HandlerMethodArgumentResolver> argumentResolvers) {
                argumentResolvers.add(new SearchFilterResolver());
            }
        };
    }

    @PostConstruct
    public void setDefaultTimezone() {
        TimeZone.setDefault(TimeZone.getTimeZone(ZoneOffset.UTC));
    }
}

