/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.FilteredItemsQueryPredicate;
import org.dspace.contentreport.Filter;
import org.dspace.contentreport.QueryOperator;

public class FilteredItemsQueryRest {
    private List<String> collections = new ArrayList<String>();
    private List<FilteredItemsQueryPredicate> queryPredicates = new ArrayList<FilteredItemsQueryPredicate>();
    private int pageLimit;
    private Set<Filter> filters = EnumSet.noneOf(Filter.class);
    private List<String> additionalFields = new ArrayList<String>();

    public static FilteredItemsQueryRest of(Collection<String> collectionUuids, Collection<FilteredItemsQueryPredicate> predicates, int pageLimit, Collection<Filter> filters, Collection<String> additionalFields) {
        FilteredItemsQueryRest query = new FilteredItemsQueryRest();
        Optional.ofNullable(collectionUuids).ifPresent(query.collections::addAll);
        Optional.ofNullable(predicates).ifPresent(query.queryPredicates::addAll);
        query.pageLimit = pageLimit;
        Optional.ofNullable(filters).ifPresent(query.filters::addAll);
        Optional.ofNullable(additionalFields).ifPresent(query.additionalFields::addAll);
        return query;
    }

    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections = collections;
    }

    public List<FilteredItemsQueryPredicate> getQueryPredicates() {
        return this.queryPredicates;
    }

    public void setQueryPredicates(List<FilteredItemsQueryPredicate> queryPredicates) {
        this.queryPredicates = queryPredicates;
    }

    public List<String> getPredicateFields() {
        if (this.queryPredicates == null) {
            return Collections.emptyList();
        }
        return this.queryPredicates.stream().map(FilteredItemsQueryPredicate::getField).collect(Collectors.toList());
    }

    public List<QueryOperator> getPredicateOperators() {
        if (this.queryPredicates == null) {
            return Collections.emptyList();
        }
        return this.queryPredicates.stream().map(FilteredItemsQueryPredicate::getOperator).collect(Collectors.toList());
    }

    public List<String> getPredicateValues() {
        if (this.queryPredicates == null) {
            return Collections.emptyList();
        }
        return this.queryPredicates.stream().map(FilteredItemsQueryPredicate::getValue).map(s -> s == null ? "" : s).collect(Collectors.toList());
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public void setPageLimit(int pageLimit) {
        this.pageLimit = pageLimit;
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Set<Filter> filters) {
        this.filters = filters;
    }

    public List<String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(List<String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public String toQueryString() {
        String colls = this.collections.stream().map(coll -> "collection=" + coll).collect(Collectors.joining("&"));
        String preds = this.queryPredicates.stream().map(pred -> "queryPredicates=" + pred).collect(Collectors.joining("&"));
        String pgLimit = "pageLimit=" + this.pageLimit;
        String fltrs = this.filters.stream().map(e -> "filters=" + e.getId()).collect(Collectors.joining("&"));
        String flds = this.additionalFields.stream().map(fld -> "additionalFields=" + fld).collect(Collectors.joining("&"));
        return Stream.of(colls, preds, pgLimit, fltrs, flds).filter(StringUtils::isNotBlank).collect(Collectors.joining("&"));
    }
}

