/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.authorization.AuthorizationRestUtil;
import org.dspace.app.rest.model.AuthorizationFeatureRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="authz.authorizations.feature")
public class AuthorizationFeatureLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private AuthorizationRestUtil authorizationRestUtil;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;

    @PreAuthorize(value="hasPermission(#authzId, 'AUTHORIZATION', 'READ')")
    public AuthorizationFeatureRest getFeature(@Nullable HttpServletRequest request, String authzId, @Nullable Pageable optionalPageable, Projection projection) {
        String featureName = this.authorizationRestUtil.getFeatureName(authzId);
        AuthorizationFeature feature = this.authorizationFeatureService.find(featureName);
        if (feature == null) {
            return null;
        }
        return (AuthorizationFeatureRest)this.converter.toRest(feature, projection);
    }
}

