/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import java.time.ZonedDateTime;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.resourcePolicy.ResourcePolicyUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Context;
import org.dspace.util.MultiFormatDateParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyEndDateReplaceOperation<R>
extends PatchOperation<R> {
    @Autowired
    ResourcePolicyUtils resourcePolicyUtils;

    @Override
    public R perform(Context context, R resource, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.resourcePolicyUtils.checkResourcePolicyForExistingEndDateValue(resourcePolicy, operation);
            this.resourcePolicyUtils.checkResourcePolicyForConsistentEndDateValue(resourcePolicy, operation);
            this.replace(resourcePolicy, operation);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    private void replace(ResourcePolicy resourcePolicy, Operation operation) {
        String dateS = (String)operation.getValue();
        ZonedDateTime date = MultiFormatDateParser.parse((String)dateS);
        if (date == null) {
            throw new DSpaceBadRequestException("Invalid endDate value " + dateS);
        }
        resourcePolicy.setEndDate(date.toLocalDate());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!(objectToMatch instanceof ResourcePolicy)) return false;
        if (!operation.getOp().trim().equalsIgnoreCase("replace")) return false;
        if (!operation.getPath().trim().equalsIgnoreCase("/endDate")) return false;
        return true;
    }
}

