/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import java.time.ZonedDateTime;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.util.MultiFormatDateParser;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyUtils {
    public static final String OPERATION_PATH_STARTDATE = "/startDate";
    public static final String OPERATION_PATH_ENDDATE = "/endDate";
    public static final String OPERATION_PATH_DESCRIPTION = "/description";
    public static final String OPERATION_PATH_NAME = "/name";
    public static final String OPERATION_PATH_POLICY_TYPE = "/policyType";
    public static final String OPERATION_PATH_ACTION = "/action";

    public void checkResourcePolicyForExistingStartDateValue(ResourcePolicy resource, Operation operation) {
        if (resource.getStartDate() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent start date value.");
        }
    }

    public void checkResourcePolicyForExistingEndDateValue(ResourcePolicy resource, Operation operation) {
        if (resource.getEndDate() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent end date value.");
        }
    }

    public void checkResourcePolicyForExistingNameValue(ResourcePolicy resource, Operation operation) {
        if (resource.getRpName() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent name value.");
        }
    }

    public void checkResourcePolicyForExistingDescriptionValue(ResourcePolicy resource, Operation operation) {
        if (resource.getRpDescription() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent description value.");
        }
    }

    public void checkResourcePolicyForConsistentStartDateValue(ResourcePolicy resource, Operation operation) {
        String dateS = (String)operation.getValue();
        ZonedDateTime date = MultiFormatDateParser.parse((String)dateS);
        if (date == null) {
            throw new DSpaceBadRequestException("Invalid startDate value " + dateS);
        }
        if (resource.getEndDate() != null && resource.getEndDate().isBefore(date.toLocalDate())) {
            throw new DSpaceBadRequestException("Attempting to set an invalid startDate greater than the endDate.");
        }
    }

    public void checkResourcePolicyForConsistentEndDateValue(ResourcePolicy resource, Operation operation) {
        String dateS = (String)operation.getValue();
        ZonedDateTime date = MultiFormatDateParser.parse((String)dateS);
        if (date == null) {
            throw new DSpaceBadRequestException("Invalid endDate value " + dateS);
        }
        if (resource.getStartDate() != null && resource.getStartDate().isAfter(date.toLocalDate())) {
            throw new DSpaceBadRequestException("Attempting to set an invalid endDate smaller than the startDate.");
        }
    }
}

