/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.item;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.util.FrontendUrlService;
import org.dspace.util.SimpleMapConverter;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemTypeProcessor
extends ItemSignpostingProcessor {
    private static final Logger log = LogManager.getLogger(ItemTypeProcessor.class);
    private static final String ABOUT_PAGE_URI = "https://schema.org/AboutPage";
    @Autowired
    private SimpleMapConverter mapConverterDSpaceToSchemaOrgUri;
    @Autowired
    private ItemService itemService;

    public ItemTypeProcessor(FrontendUrlService frontendUrlService) {
        super(frontendUrlService);
        this.setRelation(LinksetRelationType.TYPE);
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Item item, List<LinksetNode> linksetNodes) {
        try {
            linksetNodes.add(new LinksetNode(ABOUT_PAGE_URI, this.getRelation(), this.buildAnchor(context, item)));
            String type = this.itemService.getMetadataFirstValue((DSpaceObject)item, "dc", "type", null, "*");
            if (StringUtils.isNotBlank((CharSequence)type)) {
                String typeSchemeUri = this.mapConverterDSpaceToSchemaOrgUri.getValue(type);
                linksetNodes.add(new LinksetNode(typeSchemeUri, this.getRelation(), this.buildAnchor(context, item)));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

