/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"org.dspace.app.rest.converter", "org.dspace.app.rest.repository", "org.dspace.app.rest.utils", "org.dspace.app.rest.link", "org.dspace.app.rest.converter.factory", "org.dspace.app.configuration", "org.dspace.iiif", "org.dspace.app.iiif", "org.dspace.app.ldn", "org.dspace.app.scheduler"})
public class ApplicationConfig {
    @Value(value="${rest.cors.allowed-origins}")
    private String[] corsAllowedOrigins;
    @Value(value="${iiif.cors.allowed-origins}")
    private String[] iiifCorsAllowedOrigins;
    @Value(value="${signposting.cors.allowed-origins}")
    private String[] signpostingCorsAllowedOrigins;
    @Value(value="${rest.cors.allow-credentials:true}")
    private boolean corsAllowCredentials;
    @Value(value="${iiif.cors.allow-credentials:true}")
    private boolean iiifCorsAllowCredentials;
    @Value(value="${signposting.cors.allow-credentials:true}")
    private boolean signpostingCorsAllowCredentials;
    @Value(value="${dspace.ui.url:http://localhost:4000}")
    private String uiURL;
    @Value(value="${ldn.enabled}")
    private boolean ldnEnabled;

    public String[] getCorsAllowedOrigins(String[] corsOrigins) {
        if (corsOrigins != null) {
            for (int i = 0; i < corsOrigins.length; ++i) {
                if (!corsOrigins[i].endsWith("/")) continue;
                corsOrigins[i] = StringUtils.removeEnd((String)corsOrigins[i], (String)"/");
            }
            return corsOrigins;
        }
        if (this.uiURL != null) {
            return new String[]{this.uiURL};
        }
        return null;
    }

    public String[] getCorsAllowedOriginsConfig() {
        return this.corsAllowedOrigins;
    }

    public String[] getIiifAllowedOriginsConfig() {
        return this.iiifCorsAllowedOrigins;
    }

    public String[] getSignpostingAllowedOriginsConfig() {
        return this.signpostingCorsAllowedOrigins;
    }

    public boolean getCorsAllowCredentials() {
        return this.corsAllowCredentials;
    }

    public boolean getLdnEnabled() {
        return this.ldnEnabled;
    }

    public boolean getIiifAllowCredentials() {
        return this.iiifCorsAllowCredentials;
    }

    public boolean getSignpostingAllowCredentials() {
        return this.signpostingCorsAllowCredentials;
    }
}

