/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.hateoas.EPersonResource;
import org.dspace.app.rest.repository.EPersonRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/eperson/epersons"})
public class EPersonRegistrationRestController {
    @Autowired
    private EPersonRestRepository ePersonRestRepository;
    @Autowired
    private ConverterService converter;

    @RequestMapping(method={RequestMethod.POST}, value={"/{uuid}"})
    public ResponseEntity<RepresentationModel<?>> post(HttpServletRequest request, @PathVariable String uuid, @RequestParam @NotNull String token, @RequestParam(required=false) List<String> override) throws Exception {
        Context context = ContextUtil.obtainContext(request);
        try {
            context.turnOffAuthorisationSystem();
            EPersonRest epersonRest = this.ePersonRestRepository.mergeFromRegistrationData(context, UUID.fromString(uuid), token, override);
            EPersonResource resource = (EPersonResource)((Object)this.converter.toResource(epersonRest));
            ResponseEntity responseEntity = ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)resource);
            return responseEntity;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            context.restoreAuthSystemState();
        }
    }
}

