/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.LDNMessageEntityRest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ldn/messages/{id:^urn:uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/enqueueretry"})
public class LDNMessageRestController
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(LDNMessageRestController.class);
    @Autowired
    private ConverterService converterService;
    @Autowired
    private LDNMessageService ldnMessageService;
    @Autowired
    private Utils utils;
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private ObjectMapper mapper;

    public void afterPropertiesSet() {
        this.discoverableEndpointsService.register(this, List.of(Link.of((String)"/api/ldn/messages/{id}/enqueueretry", (String)"enqueueretry")));
    }

    @PostMapping(produces={"application/json"})
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ResponseEntity<String> findByItem(@PathVariable(value="id") String id) throws SQLException, AuthorizeException, JsonProcessingException {
        Context context = ContextUtil.obtainCurrentRequestContext();
        LDNMessageEntity ldnMessageEntity = this.ldnMessageService.find(context, id);
        if (ldnMessageEntity == null) {
            throw new ResourceNotFoundException("No such item: " + id);
        }
        ldnMessageEntity.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_QUEUED_FOR_RETRY);
        this.ldnMessageService.update(context, ldnMessageEntity);
        LDNMessageEntityRest resultRequestStatusRests = (LDNMessageEntityRest)this.converterService.toRest(ldnMessageEntity, this.utils.obtainProjection());
        context.complete();
        String result = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resultRequestStatusRests);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }
}

