/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.collections.adminGroup")
public class CollectionAdminGroupLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private CollectionService collectionService;

    @PreAuthorize(value="hasPermission(#collectionId, 'COLLECTION', 'READ')")
    public GroupRest getAdminGroup(@Nullable HttpServletRequest request, UUID collectionId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Collection collection = (Collection)this.collectionService.find(context, collectionId);
            if (collection == null) {
                throw new ResourceNotFoundException("No such collection: " + collectionId);
            }
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Collection)collection);
            }
            catch (AuthorizeException e) {
                throw new AccessDeniedException("The current user was not allowed to retrieve the AdminGroup for collection: " + collectionId);
            }
            Group administrators = collection.getAdministrators();
            if (administrators == null) {
                return null;
            }
            return (GroupRest)this.converter.toRest(administrators, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

