/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import org.dspace.app.rest.model.RelationshipTypeRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.relationships.relationshipType")
public class RelationshipTypeRelationshipLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    RelationshipService relationshipService;

    @PreAuthorize(value="permitAll()")
    public RelationshipTypeRest getRelationshipType(@Nullable HttpServletRequest request, Integer relationshipId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Relationship relationship = (Relationship)this.relationshipService.find(context, relationshipId.intValue());
            if (relationship == null) {
                throw new ResourceNotFoundException("No such relationship: " + relationshipId);
            }
            int total = this.relationshipService.countByRelationshipType(context, relationship.getRelationshipType());
            Pageable pageable = this.utils.getPageable(optionalPageable);
            RelationshipType relationshipType = relationship.getRelationshipType();
            return (RelationshipTypeRest)this.converter.toRest(relationshipType, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

