/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.SearchEventConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.PageRest;
import org.dspace.app.rest.model.SearchEventRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.services.EventService;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageSearchEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="statistics.searchevents")
public class SearchEventRestRepository
extends AbstractDSpaceRestRepository {
    @Autowired
    private EventService eventService;
    @Autowired
    private SearchEventConverter searchEventConverter;
    @Autowired
    private ObjectMapper mapper;

    public SearchEventRest createSearchEvent() {
        Context context = this.obtainContext();
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        SearchEventRest searchEventRest = null;
        try {
            ServletInputStream input = req.getInputStream();
            searchEventRest = (SearchEventRest)this.mapper.readValue((InputStream)input, SearchEventRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", e1);
        }
        this.checkSearchEventRestValidity(searchEventRest);
        UsageSearchEvent usageSearchEvent = this.searchEventConverter.convert(context, req, searchEventRest);
        this.eventService.fireEvent((Event)usageSearchEvent);
        return searchEventRest;
    }

    private void checkSearchEventRestValidity(SearchEventRest searchEventRest) {
        if (!this.isPageValid(searchEventRest.getPage())) {
            throw new DSpaceBadRequestException("The given page was invalid");
        }
        if (!this.isSortValid(searchEventRest.getSort())) {
            throw new DSpaceBadRequestException("The given sort was invalid");
        }
    }

    private boolean isSortValid(SearchResultsRest.Sorting sort) {
        if (sort == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)sort.getOrder(), (CharSequence)"asc") || StringUtils.equalsIgnoreCase((CharSequence)sort.getOrder(), (CharSequence)"desc");
    }

    private boolean isPageValid(PageRest page) {
        return page != null;
    }
}

