/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.LinkNotFoundException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.VocabularyEntryDetailsRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="submission.vocabularyEntryDetails")
public class VocabularyEntryDetailsRestRepository
extends DSpaceRestRepository<VocabularyEntryDetailsRest, String>
implements InitializingBean {
    @Autowired
    private ChoiceAuthorityService cas;
    @Autowired
    private AuthorityUtils authorityUtils;
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register(this, Arrays.asList(Link.of((String)"/api/submission/vocabularyEntryDetails/search", (String)"vocabularyEntryDetails-search")));
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<VocabularyEntryDetailsRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("resourcepolicy", "findAll");
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public VocabularyEntryDetailsRest findOne(Context context, String name) {
        String[] parts = StringUtils.split((String)name, (String)":", (int)2);
        if (parts.length != 2) {
            return null;
        }
        String vocabularyName = parts[0];
        String vocabularyId = parts[1];
        ChoiceAuthority source = this.cas.getChoiceAuthorityByAuthorityName(vocabularyName);
        Choice choice = source.getChoice(vocabularyId, context.getCurrentLocale().toString());
        return this.authorityUtils.convertEntryDetails(choice, vocabularyName, source.isHierarchical(), this.utils.obtainProjection());
    }

    @SearchRestMethod(name="top")
    @PreAuthorize(value="permitAll()")
    public Page<VocabularyEntryDetailsRest> findAllTop(@Parameter(value="vocabulary", required=true) String vocabularyId, Pageable pageable) {
        Context context = this.obtainContext();
        ArrayList<VocabularyEntryDetailsRest> results = new ArrayList<VocabularyEntryDetailsRest>();
        ChoiceAuthority source = this.cas.getChoiceAuthorityByAuthorityName(vocabularyId);
        if (source.isHierarchical()) {
            Choices choices = this.cas.getTopChoices(vocabularyId, (int)pageable.getOffset(), pageable.getPageSize(), context.getCurrentLocale().toString());
            for (Choice value : choices.values) {
                results.add(this.authorityUtils.convertEntryDetails(value, vocabularyId, source.isHierarchical(), this.utils.obtainProjection()));
            }
            PageImpl resources = new PageImpl(results, pageable, (long)choices.total);
            return resources;
        }
        throw new LinkNotFoundException("submission", "vocabularyEntryDetail", vocabularyId);
    }

    @Override
    public Class<VocabularyEntryDetailsRest> getDomainClass() {
        return VocabularyEntryDetailsRest.class;
    }
}

