/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.profile.OrcidEntitySyncPreference;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.dspace.profile.OrcidSynchronizationMode;
import org.dspace.profile.ResearcherProfile;
import org.dspace.profile.service.ResearcherProfileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResearcherProfileReplaceOrcidSyncPreferencesOperation
extends PatchOperation<ResearcherProfile> {
    private static final String OPERATION_ORCID_SYNCH = "/orcid";
    private static final String PUBLICATIONS_PREFERENCES = "/publications";
    private static final String FUNDINGS_PREFERENCES = "/fundings";
    private static final String PROFILE_PREFERENCES = "/profile";
    private static final String MODE_PREFERENCES = "/mode";
    @Autowired
    private ResearcherProfileService profileService;
    @Autowired
    private OrcidSynchronizationService synchronizationService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private OrcidQueueService orcidQueueService;

    @Override
    public ResearcherProfile perform(Context context, ResearcherProfile profile, Operation operation) throws SQLException {
        String path = StringUtils.removeStart((String)operation.getPath(), (String)OPERATION_ORCID_SYNCH);
        String value = this.getNewValueFromOperation(operation);
        Item profileItem = profile.getItem();
        context.turnOffAuthorisationSystem();
        try {
            boolean updated = this.updatePreferences(context, path, value, profileItem);
            if (updated) {
                this.reloadOrcidQueue(context, path, value, profileItem);
            }
            ResearcherProfile researcherProfile = this.profileService.findById(context, profile.getId());
            return researcherProfile;
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private String getNewValueFromOperation(Operation operation) {
        Object valueObject = operation.getValue();
        if (valueObject == null | !(valueObject instanceof String)) {
            throw new UnprocessableEntityException("The /orcid value must be a string");
        }
        return (String)valueObject;
    }

    private boolean updatePreferences(Context context, String path, String value, Item profileItem) throws SQLException {
        switch (path) {
            case "/publications": {
                OrcidEntitySyncPreference preference = this.parsePreference(value);
                return this.synchronizationService.setEntityPreference(context, profileItem, OrcidEntityType.PUBLICATION, preference);
            }
            case "/fundings": {
                OrcidEntitySyncPreference fundingPreference = this.parsePreference(value);
                return this.synchronizationService.setEntityPreference(context, profileItem, OrcidEntityType.FUNDING, fundingPreference);
            }
            case "/profile": {
                List<OrcidProfileSyncPreference> profilePreferences = this.parseProfilePreferences(value);
                return this.synchronizationService.setProfilePreference(context, profileItem, profilePreferences);
            }
            case "/mode": {
                return this.synchronizationService.setSynchronizationMode(context, profileItem, this.parseMode(value));
            }
        }
        throw new UnprocessableEntityException("Invalid path starting with /orcid");
    }

    private void reloadOrcidQueue(Context context, String path, String value, Item profileItem) throws SQLException, AuthorizeException {
        if (path.equals(PUBLICATIONS_PREFERENCES) || path.equals(FUNDINGS_PREFERENCES)) {
            OrcidEntitySyncPreference preference = this.parsePreference(value);
            OrcidEntityType entityType = path.equals(PUBLICATIONS_PREFERENCES) ? OrcidEntityType.PUBLICATION : OrcidEntityType.FUNDING;
            this.orcidQueueService.recalculateOrcidQueue(context, profileItem, entityType, preference);
        }
        this.itemService.update(context, (DSpaceObject)profileItem);
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof ResearcherProfile && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().toLowerCase().startsWith(OPERATION_ORCID_SYNCH);
    }

    private List<OrcidProfileSyncPreference> parseProfilePreferences(String value) {
        return Arrays.stream(value.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).map(this::parseProfilePreference).collect(Collectors.toList());
    }

    private OrcidProfileSyncPreference parseProfilePreference(String value) {
        try {
            return OrcidProfileSyncPreference.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new UnprocessableEntityException("Invalid profile's synchronization preference value: " + value, ex);
        }
    }

    private OrcidSynchronizationMode parseMode(String value) {
        try {
            return OrcidSynchronizationMode.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new UnprocessableEntityException("Invalid synchronization mode value: " + value, ex);
        }
    }

    private OrcidEntitySyncPreference parsePreference(String value) {
        try {
            return OrcidEntitySyncPreference.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new UnprocessableEntityException("Invalid synchronization preference value: " + value, ex);
        }
    }
}

