/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.security.StatelessLoginFilter;
import org.dspace.authenticate.SamlAuthentication;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class SamlLoginFilter
extends StatelessLoginFilter {
    private static final Logger logger = LogManager.getLogger(SamlLoginFilter.class);
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public SamlLoginFilter(String url, String httpMethod, AuthenticationManager authenticationManager, RestAuthenticationService restAuthenticationService) {
        super(url, httpMethod, authenticationManager, restAuthenticationService);
    }

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (!SamlAuthentication.isEnabled()) {
            throw new ProviderNotFoundException("SAML is disabled.");
        }
        return this.authenticationManager.authenticate((Authentication)new DSpaceAuthentication());
    }

    @Override
    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication auth) throws IOException, ServletException {
        this.restAuthenticationService.addAuthenticationDataForUser(request, response, (DSpaceAuthentication)auth, true);
        this.redirectAfterSuccess(request, response);
    }

    private void redirectAfterSuccess(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectUrl = this.configurationService.getProperty("dspace.ui.url");
        String redirectHostName = Utils.getHostName((String)redirectUrl);
        String serverUrl = this.configurationService.getProperty("dspace.server.url");
        boolean isRedirectAllowed = Stream.concat(Stream.of(serverUrl), Arrays.stream(this.configurationService.getArrayProperty("rest.cors.allowed-origins"))).map(url -> Utils.getHostName((String)url)).anyMatch(hostName -> hostName.equalsIgnoreCase(redirectHostName));
        if (isRedirectAllowed) {
            logger.debug("SAML redirecting to " + redirectUrl);
            response.sendRedirect(redirectUrl);
        } else {
            logger.error("SAML redirect URL {} is not allowed" + redirectUrl);
            response.sendError(400, "SAML redirect URL not allowed");
        }
    }
}

