/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.rest.model.UsageReportPointCityRest;
import org.dspace.app.rest.model.UsageReportPointCountryRest;
import org.dspace.app.rest.model.UsageReportPointDateRest;
import org.dspace.app.rest.model.UsageReportPointDsoTotalVisitsRest;
import org.dspace.app.rest.model.UsageReportRest;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.content.DatasetDSpaceObjectGenerator;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetTimeGenerator;
import org.dspace.statistics.content.DatasetTypeGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.StatisticsDataVisits;
import org.dspace.statistics.content.StatisticsListing;
import org.dspace.statistics.content.StatisticsTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UsageReportUtils {
    @Autowired
    private HandleService handleService;
    public static final String TOTAL_VISITS_REPORT_ID = "TotalVisits";
    public static final String TOTAL_VISITS_PER_MONTH_REPORT_ID = "TotalVisitsPerMonth";
    public static final String TOTAL_DOWNLOADS_REPORT_ID = "TotalDownloads";
    public static final String TOP_COUNTRIES_REPORT_ID = "TopCountries";
    public static final String TOP_CITIES_REPORT_ID = "TopCities";

    public List<UsageReportRest> getUsageReportsOfDSO(Context context, DSpaceObject dso) throws SQLException, ParseException, SolrServerException, IOException {
        ArrayList<UsageReportRest> usageReports = new ArrayList<UsageReportRest>();
        if (dso instanceof Site) {
            UsageReportRest globalUsageStats = this.resolveGlobalUsageReport(context);
            globalUsageStats.setId(dso.getID().toString() + "_TotalVisits");
            usageReports.add(globalUsageStats);
        } else {
            usageReports.add(this.createUsageReport(context, dso, TOTAL_VISITS_REPORT_ID));
            usageReports.add(this.createUsageReport(context, dso, TOTAL_VISITS_PER_MONTH_REPORT_ID));
            usageReports.add(this.createUsageReport(context, dso, TOP_COUNTRIES_REPORT_ID));
            usageReports.add(this.createUsageReport(context, dso, TOP_CITIES_REPORT_ID));
        }
        if (dso instanceof Item || dso instanceof Bitstream) {
            usageReports.add(this.createUsageReport(context, dso, TOTAL_DOWNLOADS_REPORT_ID));
        }
        return usageReports;
    }

    public UsageReportRest createUsageReport(Context context, DSpaceObject dso, String reportId) throws ParseException, SolrServerException, IOException {
        try {
            UsageReportRest usageReportRest;
            switch (reportId) {
                case "TotalVisits": {
                    usageReportRest = this.resolveTotalVisits(context, dso);
                    usageReportRest.setReportType(TOTAL_VISITS_REPORT_ID);
                    break;
                }
                case "TotalVisitsPerMonth": {
                    usageReportRest = this.resolveTotalVisitsPerMonth(context, dso);
                    usageReportRest.setReportType(TOTAL_VISITS_PER_MONTH_REPORT_ID);
                    break;
                }
                case "TotalDownloads": {
                    usageReportRest = this.resolveTotalDownloads(context, dso);
                    usageReportRest.setReportType(TOTAL_DOWNLOADS_REPORT_ID);
                    break;
                }
                case "TopCountries": {
                    usageReportRest = this.resolveTopCountries(context, dso);
                    usageReportRest.setReportType(TOP_COUNTRIES_REPORT_ID);
                    break;
                }
                case "TopCities": {
                    usageReportRest = this.resolveTopCities(context, dso);
                    usageReportRest.setReportType(TOP_CITIES_REPORT_ID);
                    break;
                }
                default: {
                    throw new ResourceNotFoundException("The given report id can't be resolved: " + reportId + "; available reports: TotalVisits, TotalVisitsPerMonth, TotalDownloads, TopCountries, TopCities");
                }
            }
            usageReportRest.setId(dso.getID() + "_" + reportId);
            return usageReportRest;
        }
        catch (SQLException e) {
            throw new SolrServerException("SQLException trying to receive statistics of: " + dso.getID());
        }
    }

    private UsageReportRest resolveGlobalUsageReport(Context context) throws SQLException, IOException, ParseException, SolrServerException {
        StatisticsListing statListing = new StatisticsListing((StatisticsData)new StatisticsDataVisits());
        DatasetDSpaceObjectGenerator dsoAxis = new DatasetDSpaceObjectGenerator();
        dsoAxis.addDsoChild(2, 10, false, -1);
        statListing.addDatasetGenerator((DatasetGenerator)dsoAxis);
        Dataset dataset = statListing.getDataset(context, 1);
        UsageReportRest usageReportRest = new UsageReportRest();
        for (int i = 0; i < dataset.getColLabels().size(); ++i) {
            String handle;
            UsageReportPointDsoTotalVisitsRest totalVisitPoint = new UsageReportPointDsoTotalVisitsRest();
            totalVisitPoint.setType("item");
            String urlOfItem = (String)((Map)dataset.getColLabelsAttrs().get(i)).get("url");
            if (urlOfItem == null || (handle = StringUtils.substringAfterLast((String)urlOfItem, (String)"handle/")) == null) continue;
            DSpaceObject dso = this.handleService.resolveToObject(context, handle);
            totalVisitPoint.setId(dso != null ? dso.getID().toString() : urlOfItem);
            totalVisitPoint.setLabel(dso != null ? dso.getName() : urlOfItem);
            totalVisitPoint.addValue("views", Integer.valueOf(dataset.getMatrix()[0][i]));
            usageReportRest.addPoint(totalVisitPoint);
        }
        usageReportRest.setReportType(TOTAL_VISITS_REPORT_ID);
        return usageReportRest;
    }

    private UsageReportRest resolveTotalVisits(Context context, DSpaceObject dso) throws SQLException, IOException, ParseException, SolrServerException {
        Dataset dataset = this.getDSOStatsDataset(context, dso, 1, dso.getType());
        UsageReportRest usageReportRest = new UsageReportRest();
        UsageReportPointDsoTotalVisitsRest totalVisitPoint = new UsageReportPointDsoTotalVisitsRest();
        totalVisitPoint.setType(StringUtils.substringAfterLast((String)dso.getClass().getName().toLowerCase(), (String)"."));
        totalVisitPoint.setId(dso.getID().toString());
        if (dataset.getColLabels().size() > 0) {
            totalVisitPoint.setLabel(dso.getName());
            totalVisitPoint.addValue("views", Integer.valueOf(dataset.getMatrix()[0][0]));
        } else {
            totalVisitPoint.setLabel(dso.getName());
            totalVisitPoint.addValue("views", 0);
        }
        usageReportRest.addPoint(totalVisitPoint);
        return usageReportRest;
    }

    private UsageReportRest resolveTotalVisitsPerMonth(Context context, DSpaceObject dso) throws SQLException, IOException, ParseException, SolrServerException {
        StatisticsTable statisticsTable = new StatisticsTable((StatisticsData)new StatisticsDataVisits(dso));
        DatasetTimeGenerator timeAxis = new DatasetTimeGenerator();
        timeAxis.setDateInterval("month", "-6", "+1");
        statisticsTable.addDatasetGenerator((DatasetGenerator)timeAxis);
        DatasetDSpaceObjectGenerator dsoAxis = new DatasetDSpaceObjectGenerator();
        dsoAxis.addDsoChild(dso.getType(), 10, false, -1);
        statisticsTable.addDatasetGenerator((DatasetGenerator)dsoAxis);
        Dataset dataset = statisticsTable.getDataset(context, 0);
        UsageReportRest usageReportRest = new UsageReportRest();
        for (int i = 0; i < dataset.getColLabels().size(); ++i) {
            UsageReportPointDateRest monthPoint = new UsageReportPointDateRest();
            monthPoint.setId((String)dataset.getColLabels().get(i));
            monthPoint.addValue("views", Integer.valueOf(dataset.getMatrix()[0][i]));
            usageReportRest.addPoint(monthPoint);
        }
        return usageReportRest;
    }

    private UsageReportRest resolveTotalDownloads(Context context, DSpaceObject dso) throws SQLException, SolrServerException, ParseException, IOException {
        if (dso instanceof Bitstream) {
            return this.resolveTotalVisits(context, dso);
        }
        if (dso instanceof Item) {
            Dataset dataset = this.getDSOStatsDataset(context, dso, 1, 0);
            UsageReportRest usageReportRest = new UsageReportRest();
            for (int i = 0; i < dataset.getColLabels().size(); ++i) {
                UsageReportPointDsoTotalVisitsRest totalDownloadsPoint = new UsageReportPointDsoTotalVisitsRest();
                totalDownloadsPoint.setType("bitstream");
                totalDownloadsPoint.setId((String)((Map)dataset.getColLabelsAttrs().get(i)).get("id"));
                totalDownloadsPoint.setLabel((String)dataset.getColLabels().get(i));
                totalDownloadsPoint.addValue("views", Integer.valueOf(dataset.getMatrix()[0][i]));
                usageReportRest.addPoint(totalDownloadsPoint);
            }
            return usageReportRest;
        }
        throw new IllegalArgumentException("TotalDownloads report only available for items and bitstreams");
    }

    private UsageReportRest resolveTopCountries(Context context, DSpaceObject dso) throws SQLException, IOException, ParseException, SolrServerException {
        Dataset dataset = this.getTypeStatsDataset(context, dso, "countryCode", 1);
        UsageReportRest usageReportRest = new UsageReportRest();
        for (int i = 0; i < dataset.getColLabels().size(); ++i) {
            UsageReportPointCountryRest countryPoint = new UsageReportPointCountryRest();
            countryPoint.setLabel((String)dataset.getColLabels().get(i));
            countryPoint.addValue("views", Integer.valueOf(dataset.getMatrix()[0][i]));
            usageReportRest.addPoint(countryPoint);
        }
        return usageReportRest;
    }

    private UsageReportRest resolveTopCities(Context context, DSpaceObject dso) throws SQLException, IOException, ParseException, SolrServerException {
        Dataset dataset = this.getTypeStatsDataset(context, dso, "city", 1);
        UsageReportRest usageReportRest = new UsageReportRest();
        for (int i = 0; i < dataset.getColLabels().size(); ++i) {
            UsageReportPointCityRest cityPoint = new UsageReportPointCityRest();
            cityPoint.setId((String)dataset.getColLabels().get(i));
            cityPoint.addValue("views", Integer.valueOf(dataset.getMatrix()[0][i]));
            usageReportRest.addPoint(cityPoint);
        }
        return usageReportRest;
    }

    private Dataset getDSOStatsDataset(Context context, DSpaceObject dso, int facetMinCount, int dsoType) throws SQLException, IOException, ParseException, SolrServerException {
        StatisticsListing statsList = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
        DatasetDSpaceObjectGenerator dsoAxis = new DatasetDSpaceObjectGenerator();
        dsoAxis.addDsoChild(dsoType, 10, false, -1);
        statsList.addDatasetGenerator((DatasetGenerator)dsoAxis);
        return statsList.getDataset(context, facetMinCount);
    }

    private Dataset getTypeStatsDataset(Context context, DSpaceObject dso, String typeAxisString, int facetMinCount) throws SQLException, IOException, ParseException, SolrServerException {
        StatisticsListing statListing = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
        DatasetTypeGenerator typeAxis = new DatasetTypeGenerator();
        typeAxis.setType(typeAxisString);
        typeAxis.setMax(100);
        statListing.addDatasetGenerator((DatasetGenerator)typeAxis);
        return statListing.getDataset(context, facetMinCount);
    }
}

