/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.scheduler.eperson;

import java.sql.SQLException;
import org.dspace.core.Context;
import org.dspace.eperson.service.RegistrationDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="eperson.registration-data.scheduler", name={"enabled"}, havingValue="true")
public class RegistrationDataScheduler {
    private static final Logger log = LoggerFactory.getLogger(RegistrationDataScheduler.class);
    @Autowired
    private RegistrationDataService registrationDataService;

    @Scheduled(cron="${eperson.registration-data.scheduler.expired-registration-data.cron:-}")
    protected void deleteExpiredRegistrationData() throws SQLException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        try {
            this.registrationDataService.deleteExpiredRegistrations(context);
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (Exception e) {
            context.abort();
            log.error("Failed to delete expired registrations", (Throwable)e);
            throw e;
        }
    }
}

