/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.PotentialDuplicateRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.Item;
import org.dspace.content.service.DuplicateDetectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.Link;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"duplicate.enable"})
@Component(value="submission.duplicates")
public class DuplicateRestRepository
extends DSpaceRestRepository<PotentialDuplicateRest, String>
implements InitializingBean {
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    DuplicateDetectionService duplicateDetectionService;
    @Autowired
    ItemService itemService;
    private static final Logger log = LogManager.getLogger();

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register(this, Arrays.asList(Link.of((String)"/api/submission/duplicates/search", (String)"duplicates-search")));
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public PotentialDuplicateRest findOne(Context context, String name) {
        throw new RepositoryMethodNotImplementedException("Duplicate detection endpoint only implements searchBy", "");
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public Page<PotentialDuplicateRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("Duplicate detection endpoint only implements searchBy", "");
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'READ')")
    @SearchRestMethod(name="findByItem")
    public Page<PotentialDuplicateRest> findByItem(@Parameter(value="uuid", required=true) UUID uuid, Pageable pageable) {
        Item item;
        List potentialDuplicates = new LinkedList();
        int total = 0;
        Context context = ContextUtil.obtainCurrentRequestContext();
        try {
            item = (Item)this.itemService.find(context, uuid);
        }
        catch (SQLException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        if (item == null) {
            throw new ResourceNotFoundException("No such item: " + uuid);
        }
        if (item.getTemplateItemOf() != null) {
            throw new IllegalArgumentException("Cannot get duplicates for template item");
        }
        try {
            potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(context, item);
        }
        catch (SearchServiceException e) {
            log.error("Search service error retrieving duplicates: {}", (Object)e.getMessage());
        }
        Page restPage = this.converter.toRestPage(potentialDuplicates, pageable, total, this.utils.obtainProjection());
        return restPage;
    }

    @Override
    public Class<PotentialDuplicateRest> getDomainClass() {
        return PotentialDuplicateRest.class;
    }
}

