/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.QATopicRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.QAEvent;
import org.dspace.core.Context;
import org.dspace.qaevent.QATopic;
import org.dspace.qaevent.service.QAEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.qualityassuranceevents.topic")
public class QAEventTopicLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private QAEventService qaEventService;

    @PreAuthorize(value="hasPermission(#id, 'QUALITYASSURANCEEVENT', 'READ')")
    public QATopicRest getTopic(@Nullable HttpServletRequest request, String id, @Nullable Pageable pageable, Projection projection) {
        String topicName;
        Context context = this.obtainContext();
        QAEvent qaEvent = this.qaEventService.findEventByEventId(id);
        if (qaEvent == null) {
            throw new ResourceNotFoundException("No qa event with ID: " + id);
        }
        String source = qaEvent.getSource();
        QATopic topic = this.qaEventService.findTopicBySourceAndNameAndTarget(context, source, topicName = qaEvent.getTopic(), null);
        if (topic == null) {
            throw new ResourceNotFoundException("No topic found with source: " + source + " topic: " + topicName);
        }
        return (QATopicRest)this.converter.toRest(topic, projection);
    }
}

