/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.sites")
public class SiteRestRepository
extends DSpaceObjectRestRepository<Site, SiteRest> {
    private final SiteService sitesv;

    @Autowired
    public SiteRestRepository(SiteService dsoService) {
        super(dsoService);
        this.sitesv = dsoService;
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public SiteRest findOne(Context context, UUID id) {
        Site site = null;
        try {
            site = (Site)this.sitesv.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (site == null) {
            return null;
        }
        return (SiteRest)this.converter.toRest(site, this.utils.obtainProjection());
    }

    @Override
    public Page<SiteRest> findAll(Context context, Pageable pageable) {
        try {
            List<Site> sites = Arrays.asList(this.sitesv.findSite(context));
            return this.converter.toRestPage(sites, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    @Override
    public Class<SiteRest> getDomainClass() {
        return SiteRest.class;
    }
}

