/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.app.rest.utils.BitstreamResource;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class BitstreamResourceAccessByToken
extends BitstreamResource {
    private String accessToken;
    private RequestItemService requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public BitstreamResourceAccessByToken(String name, UUID uuid, UUID currentUserUUID, Set<UUID> currentSpecialGroups, boolean shouldGenerateCoverPage, String accessToken) {
        super(name, uuid, currentUserUUID, currentSpecialGroups, shouldGenerateCoverPage);
        this.accessToken = accessToken;
    }

    @Override
    public void fetchDocument() {
        if (this.configurationService.getProperty("request.item.type") == null) {
            throw new RuntimeException("Request a copy is not enabled, download via access token will not be allowed");
        }
        if (this.document != null) {
            return;
        }
        try (Context fileRetrievalContext = this.initializeContext();){
            fileRetrievalContext.turnOffAuthorisationSystem();
            Bitstream bitstream = this.bitstreamService.find(fileRetrievalContext, this.uuid);
            try {
                this.requestItemService.authorizeAccessByAccessToken(fileRetrievalContext, bitstream, this.accessToken);
            }
            catch (AuthorizeException e) {
                throw new AuthorizeException("Authorization to bitstream " + this.uuid + " by access token FAILED");
            }
            if (this.shouldGenerateCoverPage) {
                byte[] coverPage = this.getCoverpageByteArray(fileRetrievalContext, bitstream);
                this.document = new BitstreamResource.BitstreamDocument(this.etag(bitstream), coverPage.length, new ByteArrayInputStream(coverPage));
            } else {
                this.document = new BitstreamResource.BitstreamDocument(bitstream.getChecksum(), bitstream.getSizeBytes(), this.bitstreamService.retrieve(fileRetrievalContext, bitstream));
            }
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
        LOG.debug("fetched document {} {}", (Object)this.shouldGenerateCoverPage, (Object)this.document);
    }
}

