/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.solr.listeners;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntInitListener
implements ServletContextListener {
    private static Log log = LogFactory.getLog(AntInitListener.class);

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            File home;
            File conf;
            File solrconfig;
            String solrHome = System.getProperty("solr.solr.home");
            if (solrHome == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    solrHome = (String)ctx.lookup("java:comp/env/solr/home");
                }
                catch (NamingException e) {
                    log.info((Object)e.getMessage());
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (solrHome == null) {
                solrHome = new File("./solr").getAbsolutePath();
            }
            if (!(solrconfig = new File(conf = new File(home = new File(solrHome), "conf"), "solrconfig.xml")).exists()) {
                conf.mkdirs();
                Project p = new Project();
                p.setBasedir(sce.getServletContext().getRealPath(""));
                p.setUserProperty("ant.file", sce.getServletContext().getRealPath("/WEB-INF/build.xml"));
                p.setProperty("solr.home", solrHome);
                p.init();
                ProjectHelper helper = ProjectHelper.getProjectHelper();
                p.addReference("ant.projectHelper", (Object)helper);
                helper.parse(p, (Object)sce.getServletContext().getResource("/WEB-INF/build.xml"));
                p.executeTarget(p.getDefaultTarget());
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

